/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthentication;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperationLinkState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceAuthenticationCBS
extends AmqpsDeviceAuthentication {
    private String PROP_KEY_STATUS_CODE = "status-code";
    public static final String SENDER_LINK_ENDPOINT_PATH = "$cbs";
    public static final String RECEIVER_LINK_ENDPOINT_PATH = "$cbs";
    private final String SENDER_LINK_TAG_PREFIX = "cbs-sender-";
    private final String RECEIVER_LINK_TAG_PREFIX = "cbs-receiver-";
    private final String CBS_TO = "$cbs";
    private final String CBS_REPLY = "cbs";
    private final String OPERATION_KEY = "operation";
    private final String TYPE_KEY = "type";
    private final String NAME_KEY = "name";
    private final String OPERATION_VALUE = "put-token";
    private final String TYPE_VALUE = "servicebus.windows.net:sastoken";
    private final String DEVICES_PATH = "/devices/";
    private long nextTag = 0L;
    private final Queue<MessageImpl> waitingMessages = new LinkedBlockingDeque<MessageImpl>();
    private Integer queueLock = new Integer(1);
    private final DeviceClientConfig deviceClientConfig;
    private CustomLogger logger;

    public AmqpsDeviceAuthenticationCBS(DeviceClientConfig deviceClientConfig) throws IllegalArgumentException {
        super(deviceClientConfig);
        this.deviceClientConfig = deviceClientConfig;
        this.senderLinkEndpointPath = "$cbs";
        this.receiverLinkEndpointPath = "$cbs";
        this.senderLinkTag = "cbs-sender-" + this.senderLinkTag;
        this.receiverLinkTag = "cbs-receiver-" + this.receiverLinkTag;
        this.senderLinkAddress = this.senderLinkEndpointPath;
        this.receiverLinkAddress = this.receiverLinkEndpointPath;
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:api-version"), TransportUtils.IOTHUB_API_VERSION);
        this.amqpProperties.put(Symbol.getSymbol((String)"iothub-connection-device-id"), deviceClientConfig.getDeviceId());
        this.logger = new CustomLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAuthenticationMessages() throws TransportException {
        Integer n = this.queueLock;
        synchronized (n) {
            while (!this.waitingMessages.isEmpty()) {
                int length;
                byte[] msgData = new byte[1024];
                MessageImpl outgoingMessage = this.waitingMessages.remove();
                while (true) {
                    try {
                        length = outgoingMessage.encode(msgData, 0, msgData.length);
                    }
                    catch (BufferOverflowException e) {
                        msgData = new byte[msgData.length * 2];
                        continue;
                    }
                    break;
                }
                byte[] deliveryTag = String.valueOf(this.nextTag++).getBytes();
                this.sendMessageAndGetDeliveryHash(MessageType.CBS_AUTHENTICATION, msgData, 0, length, deliveryTag);
            }
        }
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, TransportException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.CBS_AUTHENTICATION);
        }
        return amqpsMessage;
    }

    @Override
    protected Boolean authenticationMessageReceived(AmqpsMessage amqpsMessage, UUID authenticationCorrelationId) {
        Properties properties;
        Object correlationIdValue;
        if (amqpsMessage != null && amqpsMessage.getApplicationProperties() != null && amqpsMessage.getProperties() != null && (correlationIdValue = (properties = amqpsMessage.getProperties()).getCorrelationId()).equals(authenticationCorrelationId)) {
            Map applicationProperties = amqpsMessage.getApplicationProperties().getValue();
            for (Map.Entry entry : applicationProperties.entrySet()) {
                int propertyValue;
                String propertyKey = (String)entry.getKey();
                if (!propertyKey.equals(this.PROP_KEY_STATUS_CODE) || !(entry.getValue() instanceof Integer) || (propertyValue = ((Integer)entry.getValue()).intValue()) != 200) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setSslDomain(Transport transport) throws TransportException {
        Sasl sasl = transport.sasl();
        sasl.setMechanisms(new String[]{"ANONYMOUS"});
        SslDomain domain = null;
        try {
            domain = this.makeDomain(this.deviceClientConfig.getAuthenticationProvider().getSSLContext());
        }
        catch (IOException e) {
            this.logger.LogDebug("setSslDomain has thrown exception: %s", e.getMessage());
            throw new TransportException(e);
        }
        transport.ssl(domain);
    }

    @Override
    protected void authenticate(DeviceClientConfig deviceClientConfig, UUID correlationId) throws TransportException {
        MessageImpl outgoingMessage = this.createCBSAuthenticationMessage(deviceClientConfig, correlationId);
        this.waitingMessages.add(outgoingMessage);
    }

    @Override
    protected Boolean isLinkFound(String linkName) {
        if (linkName.equals(this.getSenderLinkTag())) {
            this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        if (linkName.equals(this.getReceiverLinkTag())) {
            this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        return false;
    }

    private MessageImpl createCBSAuthenticationMessage(DeviceClientConfig deviceClientConfig, UUID messageId) throws TransportException {
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        properties.setMessageId((Object)messageId);
        properties.setTo("$cbs");
        properties.setReplyTo("cbs");
        outgoingMessage.setProperties(properties);
        HashMap<String, String> userProperties = new HashMap<String, String>(3);
        userProperties.put("operation", "put-token");
        userProperties.put("type", "servicebus.windows.net:sastoken");
        String host = deviceClientConfig.getGatewayHostname();
        if (host == null || host.isEmpty()) {
            host = deviceClientConfig.getIotHubHostname();
        }
        userProperties.put("name", host + "/devices/" + deviceClientConfig.getDeviceId());
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        outgoingMessage.setApplicationProperties(applicationProperties);
        AmqpValue section = null;
        try {
            section = new AmqpValue((Object)deviceClientConfig.getSasTokenAuthentication().getRenewedSasToken());
            outgoingMessage.setBody((Section)section);
        }
        catch (IOException e) {
            this.logger.LogDebug("getRenewedSasToken has thrown exception: %s", e.getMessage());
            outgoingMessage = null;
            throw new TransportException(e);
        }
        return outgoingMessage;
    }
}

