/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperationLinkState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceMethods
extends AmqpsDeviceOperations {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String CORRELATION_ID_KEY_PREFIX = "methods:";
    private static final String APPLICATION_PROPERTY_KEY_IOTHUB_METHOD_NAME = "IoThub-methodname";
    private static final String APPLICATION_PROPERTY_KEY_IOTHUB_STATUS = "IoThub-status";
    private static final String SENDER_LINK_ENDPOINT_PATH = "/devices/%s/methods/devicebound";
    private static final String RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/methods/devicebound";
    private static final String SENDER_LINK_ENDPOINT_PATH_MODULES = "/devices/%s/modules/%s/methods/devicebound";
    private static final String RECEIVER_LINK_ENDPOINT_PATH_MODULES = "/devices/%s/modules/%s/methods/devicebound";
    private static final String SENDER_LINK_TAG_PREFIX = "sender_link_devicemethods-";
    private static final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_devicemethods-";
    private DeviceClientConfig deviceClientConfig;

    AmqpsDeviceMethods(DeviceClientConfig deviceClientConfig) throws IllegalArgumentException {
        super(deviceClientConfig, "/devices/%s/methods/devicebound", "/devices/%s/methods/devicebound", "/devices/%s/modules/%s/methods/devicebound", "/devices/%s/modules/%s/methods/devicebound", SENDER_LINK_TAG_PREFIX, RECEIVER_LINK_TAG_PREFIX);
        this.deviceClientConfig = deviceClientConfig;
        String moduleId = this.deviceClientConfig.getModuleId();
        if (moduleId != null && !moduleId.isEmpty()) {
            this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(CORRELATION_ID_KEY_PREFIX + UUID.randomUUID().toString())));
        } else {
            this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(CORRELATION_ID_KEY_PREFIX + UUID.randomUUID().toString())));
        }
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:api-version"), TransportUtils.IOTHUB_API_VERSION);
    }

    @Override
    protected Boolean isLinkFound(String linkName) {
        if (linkName.equals(this.getSenderLinkTag())) {
            this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        if (linkName.equals(this.getReceiverLinkTag())) {
            this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        return false;
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (messageType == MessageType.DEVICE_METHODS) {
            return super.sendMessageAndGetDeliveryHash(messageType, msgData, offset, length, deliveryTag);
        }
        return new AmqpsSendReturnValue(false, -1);
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws TransportException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.DEVICE_METHODS);
            amqpsMessage.setDeviceClientConfig(this.deviceClientConfig);
        }
        return amqpsMessage;
    }

    @Override
    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws TransportException {
        if (amqpsMessage.getAmqpsMessageType() == MessageType.DEVICE_METHODS && this.deviceClientConfig.getDeviceId() == deviceClientConfig.getDeviceId()) {
            IotHubTransportMessage message = this.protonMessageToIoTHubMessage(amqpsMessage);
            MessageCallback messageCallback = deviceClientConfig.getDeviceMethodsMessageCallback();
            Object messageContext = deviceClientConfig.getDeviceMethodsMessageContext();
            return new AmqpsConvertFromProtonReturnValue(message, messageCallback, messageContext);
        }
        return null;
    }

    @Override
    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) throws TransportException {
        if (message.getMessageType() == MessageType.DEVICE_METHODS) {
            MessageImpl protonMessage = this.iotHubMessageToProtonMessage(message);
            return new AmqpsConvertToProtonReturnValue(protonMessage, MessageType.DEVICE_METHODS);
        }
        return null;
    }

    @Override
    protected IotHubTransportMessage protonMessageToIoTHubMessage(MessageImpl protonMsg) throws TransportException {
        Map applicationProperties;
        IotHubTransportMessage iotHubTransportMessage = super.protonMessageToIoTHubMessage(protonMsg);
        iotHubTransportMessage.setMessageType(MessageType.DEVICE_METHODS);
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
        if (protonMsg.getApplicationProperties() != null && protonMsg.getApplicationProperties().getValue() != null && (applicationProperties = protonMsg.getApplicationProperties().getValue()).containsKey(APPLICATION_PROPERTY_KEY_IOTHUB_METHOD_NAME)) {
            iotHubTransportMessage.setMethodName(applicationProperties.get(APPLICATION_PROPERTY_KEY_IOTHUB_METHOD_NAME).toString());
        }
        if (protonMsg.getProperties() != null && protonMsg.getProperties().getCorrelationId() != null) {
            iotHubTransportMessage.setRequestId(protonMsg.getProperties().getCorrelationId().toString());
        }
        return iotHubTransportMessage;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) throws TransportException {
        MessageImpl protonMessage = super.iotHubMessageToProtonMessage(message);
        IotHubTransportMessage deviceMethodMessage = (IotHubTransportMessage)message;
        Properties properties = protonMessage.getProperties() != null ? protonMessage.getProperties() : new Properties();
        if (deviceMethodMessage.getRequestId() != null) {
            properties.setCorrelationId((Object)UUID.fromString(deviceMethodMessage.getRequestId()));
        }
        protonMessage.setProperties(properties);
        HashMap<String, Integer> userProperties = new HashMap<String, Integer>();
        if (deviceMethodMessage.getStatus() != null) {
            userProperties.put(APPLICATION_PROPERTY_KEY_IOTHUB_STATUS, Integer.parseInt(deviceMethodMessage.getStatus()));
        }
        Map applicationPropertiesMap = new HashMap();
        if (protonMessage.getApplicationProperties() != null && protonMessage.getApplicationProperties().getValue() != null) {
            applicationPropertiesMap = protonMessage.getApplicationProperties().getValue();
            userProperties.putAll(applicationPropertiesMap);
        }
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        protonMessage.setApplicationProperties(applicationProperties);
        return protonMessage;
    }
}

