/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperationLinkState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.util.HashMap;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceTelemetry
extends AmqpsDeviceOperations {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String SENDER_LINK_ENDPOINT_PATH = "/devices/%s/messages/events";
    private static final String RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/messages/devicebound";
    private static final String SENDER_LINK_ENDPOINT_PATH_MODULES = "/devices/%s/modules/%s/messages/events";
    private static final String RECEIVER_LINK_ENDPOINT_PATH_MODULES = "/devices/%s/modules/%s/messages/devicebound";
    private static final String SENDER_LINK_TAG_PREFIX = "sender_link_telemetry-";
    private static final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_telemetry-";
    private DeviceClientConfig deviceClientConfig;

    AmqpsDeviceTelemetry(DeviceClientConfig deviceClientConfig) throws IllegalArgumentException {
        super(deviceClientConfig, SENDER_LINK_ENDPOINT_PATH, RECEIVER_LINK_ENDPOINT_PATH, SENDER_LINK_ENDPOINT_PATH_MODULES, RECEIVER_LINK_ENDPOINT_PATH_MODULES, SENDER_LINK_TAG_PREFIX, RECEIVER_LINK_TAG_PREFIX);
        this.deviceClientConfig = deviceClientConfig;
        String moduleId = this.deviceClientConfig.getModuleId();
        if (moduleId != null && !moduleId.isEmpty()) {
            this.senderLinkEndpointPath = SENDER_LINK_ENDPOINT_PATH_MODULES;
            this.receiverLinkEndpointPath = RECEIVER_LINK_ENDPOINT_PATH_MODULES;
            this.senderLinkTag = SENDER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "/" + moduleId + "-" + this.senderLinkTag;
            this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "/" + moduleId + "-" + this.receiverLinkTag;
            this.senderLinkAddress = String.format(this.senderLinkEndpointPath, this.deviceClientConfig.getDeviceId(), moduleId);
            this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, this.deviceClientConfig.getDeviceId(), moduleId);
            this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(this.deviceClientConfig.getDeviceId() + "/" + moduleId)));
        } else {
            this.senderLinkEndpointPath = SENDER_LINK_ENDPOINT_PATH;
            this.receiverLinkEndpointPath = RECEIVER_LINK_ENDPOINT_PATH;
            this.senderLinkTag = SENDER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "-" + this.senderLinkTag;
            this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "-" + this.receiverLinkTag;
            this.senderLinkAddress = String.format(this.senderLinkEndpointPath, this.deviceClientConfig.getDeviceId());
            this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, this.deviceClientConfig.getDeviceId());
            this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)this.deviceClientConfig.getDeviceId()));
        }
    }

    @Override
    protected Boolean isLinkFound(String linkName) {
        if (linkName.equals(this.getSenderLinkTag())) {
            this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        if (linkName.equals(this.getReceiverLinkTag())) {
            this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        return false;
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (messageType == MessageType.DEVICE_TELEMETRY) {
            return super.sendMessageAndGetDeliveryHash(messageType, msgData, offset, length, deliveryTag);
        }
        return new AmqpsSendReturnValue(false, -1);
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws TransportException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.DEVICE_TELEMETRY);
            amqpsMessage.setDeviceClientConfig(this.deviceClientConfig);
        }
        return amqpsMessage;
    }

    @Override
    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws TransportException {
        if ((amqpsMessage.getAmqpsMessageType() == null || amqpsMessage.getAmqpsMessageType() == MessageType.DEVICE_TELEMETRY) && this.deviceClientConfig.getDeviceId() == deviceClientConfig.getDeviceId()) {
            IotHubTransportMessage message = this.protonMessageToIoTHubMessage(amqpsMessage);
            MessageCallback messageCallback = deviceClientConfig.getDeviceTelemetryMessageCallback(message.getInputName());
            Object messageContext = deviceClientConfig.getDeviceTelemetryMessageContext(message.getInputName());
            return new AmqpsConvertFromProtonReturnValue(message, messageCallback, messageContext);
        }
        return null;
    }

    @Override
    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) throws TransportException {
        if (message.getMessageType() == null || message.getMessageType() == MessageType.DEVICE_TELEMETRY) {
            MessageImpl protonMessage = this.iotHubMessageToProtonMessage(message);
            return new AmqpsConvertToProtonReturnValue(protonMessage, MessageType.DEVICE_TELEMETRY);
        }
        return null;
    }

    @Override
    protected IotHubTransportMessage protonMessageToIoTHubMessage(MessageImpl protonMsg) throws TransportException {
        IotHubTransportMessage iotHubTransportMessage = super.protonMessageToIoTHubMessage(protonMsg);
        iotHubTransportMessage.setMessageType(MessageType.DEVICE_TELEMETRY);
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
        return iotHubTransportMessage;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) throws TransportException {
        MessageImpl protonMessage = super.iotHubMessageToProtonMessage(message);
        if (message.getOutputName() != null && protonMessage.getApplicationProperties() != null && protonMessage.getApplicationProperties().getValue() != null) {
            HashMap<String, String> userProperties = new HashMap<String, String>();
            userProperties.put("iothub-outputname", message.getOutputName());
            userProperties.putAll(protonMessage.getApplicationProperties().getValue());
            protonMessage.setApplicationProperties(new ApplicationProperties(userProperties));
        }
        return protonMessage;
    }
}

