/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperationLinkState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceTwin
extends AmqpsDeviceOperations {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String CORRELATION_ID_KEY_PREFIX = "twin:";
    private static final String SENDER_LINK_ENDPOINT_PATH = "/devices/%s/twin";
    private static final String RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/twin";
    private static final String SENDER_LINK_ENDPOINT_PATH_MODULES = "/devices/%s/modules/%s/twin";
    private static final String RECEIVER_LINK_ENDPOINT_PATH_MODULES = "/devices/%s/modules/%s/twin";
    private static final String SENDER_LINK_TAG_PREFIX = "sender_link_devicetwin-";
    private static final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_devicetwin-";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_OPERATION = "operation";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE = "resource";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_STATUS = "status";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_VERSION = "version";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_GET = "GET";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PATCH = "PATCH";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PUT = "PUT";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_DELETE = "DELETE";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_REPORTED = "/properties/reported";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_NOTIFICATIONS_TWIN_PROPERTIES_DESIRED = "/notifications/twin/properties/desired";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_DESIRED = "/properties/desired";
    Map<String, DeviceOperations> correlationIdList;
    private DeviceClientConfig deviceClientConfig;

    AmqpsDeviceTwin(DeviceClientConfig deviceClientConfig) throws IllegalArgumentException {
        super(deviceClientConfig, "/devices/%s/twin", "/devices/%s/twin", "/devices/%s/modules/%s/twin", "/devices/%s/modules/%s/twin", SENDER_LINK_TAG_PREFIX, RECEIVER_LINK_TAG_PREFIX);
        this.deviceClientConfig = deviceClientConfig;
        String moduleId = this.deviceClientConfig.getModuleId();
        if (moduleId != null && !moduleId.isEmpty()) {
            this.senderLinkEndpointPath = "/devices/%s/modules/%s/twin";
            this.receiverLinkEndpointPath = "/devices/%s/modules/%s/twin";
            this.senderLinkTag = SENDER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "/" + moduleId + "-" + this.senderLinkTag;
            this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "/" + moduleId + "-" + this.receiverLinkTag;
            this.senderLinkAddress = String.format(this.senderLinkEndpointPath, this.deviceClientConfig.getDeviceId(), moduleId);
            this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, this.deviceClientConfig.getDeviceId(), moduleId);
        } else {
            this.senderLinkEndpointPath = "/devices/%s/twin";
            this.receiverLinkEndpointPath = "/devices/%s/twin";
            this.senderLinkTag = SENDER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "-" + this.senderLinkTag;
            this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX + this.deviceClientConfig.getDeviceId() + "-" + this.receiverLinkTag;
            this.senderLinkAddress = String.format(this.senderLinkEndpointPath, this.deviceClientConfig.getDeviceId());
            this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, this.deviceClientConfig.getDeviceId());
        }
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:api-version"), TransportUtils.IOTHUB_API_VERSION);
        this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(CORRELATION_ID_KEY_PREFIX + UUID.randomUUID().toString())));
        this.correlationIdList = new HashMap<String, DeviceOperations>();
    }

    @Override
    protected Boolean isLinkFound(String linkName) {
        if (linkName.equals(this.getSenderLinkTag())) {
            this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        if (linkName.equals(this.getReceiverLinkTag())) {
            this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.OPENED;
            return true;
        }
        return false;
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (messageType == MessageType.DEVICE_TWIN) {
            return super.sendMessageAndGetDeliveryHash(messageType, msgData, offset, length, deliveryTag);
        }
        return new AmqpsSendReturnValue(false, -1);
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, TransportException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.DEVICE_TWIN);
            amqpsMessage.setDeviceClientConfig(this.deviceClientConfig);
        }
        return amqpsMessage;
    }

    @Override
    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws TransportException {
        if (amqpsMessage.getAmqpsMessageType() == MessageType.DEVICE_TWIN && this.deviceClientConfig.getDeviceId() == deviceClientConfig.getDeviceId()) {
            IotHubTransportMessage message = this.protonMessageToIoTHubMessage(amqpsMessage);
            MessageCallback messageCallback = deviceClientConfig.getDeviceTwinMessageCallback();
            Object messageContext = deviceClientConfig.getDeviceTwinMessageContext();
            return new AmqpsConvertFromProtonReturnValue(message, messageCallback, messageContext);
        }
        return null;
    }

    @Override
    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) throws TransportException {
        if (message.getMessageType() == MessageType.DEVICE_TWIN) {
            MessageImpl protonMessage = this.iotHubMessageToProtonMessage(message);
            return new AmqpsConvertToProtonReturnValue(protonMessage, MessageType.DEVICE_TWIN);
        }
        return null;
    }

    @Override
    protected IotHubTransportMessage protonMessageToIoTHubMessage(MessageImpl protonMsg) throws TransportException {
        Properties properties;
        IotHubTransportMessage iotHubTransportMessage = super.protonMessageToIoTHubMessage(protonMsg);
        iotHubTransportMessage.setMessageType(MessageType.DEVICE_TWIN);
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
        MessageAnnotations messageAnnotations = protonMsg.getMessageAnnotations();
        if (messageAnnotations != null) {
            for (Map.Entry entry : messageAnnotations.getValue().entrySet()) {
                Symbol key = (Symbol)entry.getKey();
                Object value = entry.getValue();
                if (key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_STATUS)) {
                    iotHubTransportMessage.setStatus(value.toString());
                    continue;
                }
                if (key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_VERSION)) {
                    iotHubTransportMessage.setVersion(value.toString());
                    continue;
                }
                if (!key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE) || !value.toString().equals(MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_DESIRED)) continue;
                iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
            }
        }
        if ((properties = protonMsg.getProperties()) != null) {
            if (properties.getCorrelationId() != null) {
                iotHubTransportMessage.setCorrelationId(properties.getCorrelationId().toString());
                if (this.correlationIdList.containsKey(properties.getCorrelationId().toString())) {
                    DeviceOperations deviceOperations = this.correlationIdList.get(properties.getCorrelationId().toString());
                    switch (deviceOperations) {
                        case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_RESPONSE);
                            break;
                        }
                        case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE);
                            break;
                        }
                        case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                            break;
                        }
                        case DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                            break;
                        }
                        default: {
                            TransportUtils.throwTransportExceptionWithIotHubServiceType("Invalid device operation type in protonMessageToIoTHubMessage!", TransportException.IotHubService.TWIN);
                        }
                    }
                    this.correlationIdList.remove(properties.getCorrelationId().toString());
                }
            } else if (iotHubTransportMessage.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_UNKNOWN) {
                iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
            }
        }
        return iotHubTransportMessage;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) throws TransportException {
        MessageImpl protonMessage = super.iotHubMessageToProtonMessage(message);
        IotHubTransportMessage deviceTwinMessage = (IotHubTransportMessage)message;
        if (deviceTwinMessage.getCorrelationId() != null) {
            protonMessage.getProperties().setCorrelationId((Object)UUID.fromString(deviceTwinMessage.getCorrelationId()));
            this.correlationIdList.put(deviceTwinMessage.getCorrelationId(), deviceTwinMessage.getDeviceOperationType());
        }
        HashMap<Symbol, Object> messageAnnotationsMap = new HashMap<Symbol, Object>();
        switch (deviceTwinMessage.getDeviceOperationType()) {
            case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_GET);
                break;
            }
            case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_PATCH);
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE), MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_REPORTED);
                if (deviceTwinMessage.getVersion() == null) break;
                try {
                    messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_VERSION), Long.parseLong(deviceTwinMessage.getVersion()));
                }
                catch (NumberFormatException e) {
                    TransportUtils.throwTransportExceptionWithIotHubServiceType(e, TransportException.IotHubService.TWIN);
                }
                break;
            }
            case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_PUT);
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE), MESSAGE_ANNOTATION_FIELD_VALUE_NOTIFICATIONS_TWIN_PROPERTIES_DESIRED);
                break;
            }
            case DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_DELETE);
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE), MESSAGE_ANNOTATION_FIELD_VALUE_NOTIFICATIONS_TWIN_PROPERTIES_DESIRED);
                break;
            }
            default: {
                TransportUtils.throwTransportExceptionWithIotHubServiceType("Invalid device operation type in iotHubMessageToProtonMessage!", TransportException.IotHubService.TWIN);
            }
        }
        if (protonMessage.getMessageAnnotations() != null && protonMessage.getMessageAnnotations().getValue() != null) {
            messageAnnotationsMap.putAll(protonMessage.getMessageAnnotations().getValue());
        }
        MessageAnnotations messageAnnotations = new MessageAnnotations(messageAnnotationsMap);
        protonMessage.setMessageAnnotations(messageAnnotations);
        return protonMessage;
    }
}

