/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.exceptions.ProtocolException;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.PahoExceptionTranslator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttConnection {
    private MqttAsyncClient mqttAsyncClient = null;
    private MqttConnectOptions connectionOptions = null;
    private ConcurrentLinkedQueue<Pair<String, byte[]>> allReceivedMessages;
    private Object mqttLock;
    private MqttCallback mqttCallback;
    private static final int KEEP_ALIVE_INTERVAL = 230;
    private static final int MQTT_VERSION = 4;
    private static final boolean SET_CLEAN_SESSION = false;
    static final int QOS = 1;
    static final int MAX_WAIT_TIME = 1000;
    static final int MAX_IN_FLIGHT_COUNT = 10;

    MqttConnection(String serverURI, String clientId, String userName, String password, SSLContext iotHubSSLContext) throws TransportException, IllegalArgumentException {
        if (serverURI == null || clientId == null || userName == null || iotHubSSLContext == null) {
            throw new IllegalArgumentException("ServerURI, clientId, and userName may not be null or empty");
        }
        if (serverURI.isEmpty() || clientId.isEmpty() || userName.isEmpty()) {
            throw new IllegalArgumentException("ServerURI, clientId, and userName may not be null or empty");
        }
        try {
            this.mqttAsyncClient = new MqttAsyncClient(serverURI, clientId, (MqttClientPersistence)new MemoryPersistence());
            this.mqttAsyncClient.setManualAcks(true);
            this.connectionOptions = new MqttConnectOptions();
            this.updateConnectionOptions(userName, password, iotHubSSLContext);
        }
        catch (MqttException e) {
            this.mqttAsyncClient = null;
            this.connectionOptions = null;
            ProtocolException transportException = PahoExceptionTranslator.convertToMqttException(e, "Unable to create mqttAsyncClient");
            throw transportException;
        }
        this.allReceivedMessages = new ConcurrentLinkedQueue();
        this.mqttLock = new Object();
    }

    private void updateConnectionOptions(String userName, String userPassword, SSLContext iotHubSSLContext) {
        this.connectionOptions.setKeepAliveInterval(230);
        this.connectionOptions.setCleanSession(false);
        this.connectionOptions.setMqttVersion(4);
        this.connectionOptions.setUserName(userName);
        this.connectionOptions.setSocketFactory((SocketFactory)iotHubSSLContext.getSocketFactory());
        if (userPassword != null && !userPassword.isEmpty()) {
            this.connectionOptions.setPassword(userPassword.toCharArray());
        }
    }

    void setMqttCallback(MqttCallback mqttCallback) throws IllegalArgumentException {
        if (mqttCallback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.mqttCallback = mqttCallback;
        this.getMqttAsyncClient().setCallback(mqttCallback);
    }

    MqttAsyncClient getMqttAsyncClient() {
        return this.mqttAsyncClient;
    }

    boolean isConnected() {
        if (this.mqttAsyncClient != null) {
            return this.mqttAsyncClient.isConnected();
        }
        return false;
    }

    IMqttToken disconnect() throws MqttException {
        if (this.mqttAsyncClient != null) {
            return this.mqttAsyncClient.disconnect();
        }
        return null;
    }

    void close() throws MqttException {
        if (this.mqttAsyncClient != null) {
            this.mqttAsyncClient.close();
        }
    }

    ConcurrentLinkedQueue<Pair<String, byte[]>> getAllReceivedMessages() {
        return this.allReceivedMessages;
    }

    Object getMqttLock() {
        return this.mqttLock;
    }

    MqttConnectOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    void setMqttAsyncClient(MqttAsyncClient mqttAsyncClient) {
        this.mqttAsyncClient = mqttAsyncClient;
    }

    boolean sendMessageAcknowledgement(int messageId) throws TransportException {
        try {
            this.mqttAsyncClient.messageArrivedComplete(messageId, 1);
            return true;
        }
        catch (MqttException e) {
            throw PahoExceptionTranslator.convertToMqttException(e, "Error sending message ack");
        }
    }
}

