/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.fileupload;

import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import java.io.IOException;
import java.util.concurrent.Future;

public final class FileUploadInProgress {
    private IotHubEventCallback statusCallback;
    private Object statusCallbackContext;
    private Future task;

    FileUploadInProgress(IotHubEventCallback statusCallback, Object statusCallbackContext) throws IllegalArgumentException {
        if (statusCallback == null) {
            throw new IllegalArgumentException("status callback is null");
        }
        this.statusCallback = statusCallback;
        this.statusCallbackContext = statusCallbackContext;
    }

    void setTask(Future task) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("future task is null");
        }
        this.task = task;
    }

    void triggerCallback(IotHubStatusCode iotHubStatusCode) {
        this.statusCallback.execute(iotHubStatusCode, this.statusCallbackContext);
    }

    boolean isCancelled() throws IOException {
        if (this.task == null) {
            throw new IOException("future task is null");
        }
        return this.task.isCancelled();
    }
}

