/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.hsm;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenWithRefreshAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.SignatureProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.hsm.HsmException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;

public class IotHubSasTokenHsmAuthenticationProvider
extends IotHubSasTokenWithRefreshAuthenticationProvider {
    SignatureProvider signatureProvider;
    String generationId;

    public static IotHubSasTokenHsmAuthenticationProvider create(SignatureProvider signatureProvider, String deviceId, String moduleId, String hostname, String gatewayHostname, String generationId, int suggestedTimeToLiveSeconds, int timeBufferPercentage) throws IOException, TransportException {
        if (signatureProvider == null) {
            throw new IllegalArgumentException("signatureProvider cannot be null");
        }
        IotHubSasToken sasToken = IotHubSasTokenHsmAuthenticationProvider.createNewSasToken(hostname, gatewayHostname, deviceId, moduleId, generationId, signatureProvider, suggestedTimeToLiveSeconds);
        return new IotHubSasTokenHsmAuthenticationProvider(hostname, gatewayHostname, deviceId, moduleId, generationId, sasToken.getSasToken(), signatureProvider, suggestedTimeToLiveSeconds, timeBufferPercentage);
    }

    @Override
    public void refreshSasToken() throws IOException, TransportException {
        this.sasToken = IotHubSasTokenHsmAuthenticationProvider.createNewSasToken(this.hostname, this.gatewayHostname, this.deviceId, this.moduleId, this.generationId, this.signatureProvider, this.tokenValidSecs);
    }

    @Override
    public boolean canRefreshToken() {
        return true;
    }

    static IotHubSasToken createNewSasToken(String hostname, String gatewayHostName, String deviceId, String moduleId, String generationId, SignatureProvider signatureProvider, long suggestedTimeToLive) throws IOException, TransportException {
        try {
            String audience = IotHubSasTokenHsmAuthenticationProvider.buildAudience(hostname, deviceId, moduleId);
            long expiresOn = System.currentTimeMillis() / 1000L + suggestedTimeToLive;
            String data = audience + "\n" + expiresOn;
            String signature = signatureProvider.sign(moduleId, data, generationId);
            String host = gatewayHostName != null && !gatewayHostName.isEmpty() ? gatewayHostName : hostname;
            String sharedAccessToken = IotHubSasToken.buildSharedAccessToken(audience, signature, expiresOn);
            return new IotHubSasToken(host, deviceId, null, sharedAccessToken, moduleId, expiresOn);
        }
        catch (HsmException | UnsupportedEncodingException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private IotHubSasTokenHsmAuthenticationProvider(String hostname, String gatewayHostName, String deviceId, String moduleId, String generationId, String sharedAccessToken, SignatureProvider signatureProvider, int suggestedTimeToLiveSeconds, int timeBufferPercentage) {
        super(hostname, gatewayHostName, deviceId, moduleId, sharedAccessToken, suggestedTimeToLiveSeconds, timeBufferPercentage);
        this.signatureProvider = signatureProvider;
        this.generationId = generationId;
    }
}

