/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogger {
    private final Logger logger;
    private static final int CALLING_METHOD_NAME_DEPTH = 2;

    public CustomLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public void LogInfo(String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format(message, params));
        }
    }

    public void LogDebug(String message, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format(message, params));
        }
    }

    public void LogDebug(String message, Throwable t, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format(message, params), t);
        }
    }

    public void LogTrace(String message, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format(message, params));
        }
    }

    public void LogWarn(String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(String.format(message, params));
        }
    }

    public void LogFatal(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(String.format(message, params));
        }
    }

    public void LogError(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(String.format(message, params));
        }
    }

    public void LogError(Throwable exception) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(exception.toString());
        }
    }

    public String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }
}

