/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class IotHubConnectionString {
    private static final String HOSTNAME_ATTRIBUTE = "HostName=";
    private static final String DEVICE_ID_ATTRIBUTE = "DeviceId=";
    private static final String SHARED_ACCESS_KEY_ATTRIBUTE = "SharedAccessKey=";
    private static final String SHARED_ACCESS_TOKEN_ATTRIBUTE = "SharedAccessSignature=";
    private static final String MODULE_ID_ATTRIBUTE = "ModuleId=";
    private static final String GATEWAY_HOST_NAME_ATTRIBUTE = "GatewayHostName=";
    private static final String X509_ENABLED_ATTRIBUTE = "x509=true";
    private static final Charset CONNECTION_STRING_CHARSET = StandardCharsets.UTF_8;
    private String hostName = null;
    private String hubName = null;
    private String deviceId = null;
    private String sharedAccessKey = null;
    private String sharedAccessToken = null;
    private String moduleId = null;
    private boolean isUsingX509 = false;
    private CustomLogger logger = null;
    private String gatewayHostName = null;

    public IotHubConnectionString(String connectionString) throws IllegalArgumentException, SecurityException, URISyntaxException {
        String[] connStringAttrs;
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("The connection string cannot be null or empty.");
        }
        for (String attr : connStringAttrs = connectionString.split(";")) {
            if (attr.startsWith(HOSTNAME_ATTRIBUTE)) {
                this.hostName = attr.substring(HOSTNAME_ATTRIBUTE.length());
                continue;
            }
            if (attr.startsWith(DEVICE_ID_ATTRIBUTE)) {
                String urlEncodedDeviceId = attr.substring(DEVICE_ID_ATTRIBUTE.length());
                try {
                    this.deviceId = URLDecoder.decode(urlEncodedDeviceId, CONNECTION_STRING_CHARSET.name());
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (attr.startsWith(SHARED_ACCESS_KEY_ATTRIBUTE)) {
                this.sharedAccessKey = attr.substring(SHARED_ACCESS_KEY_ATTRIBUTE.length());
                continue;
            }
            if (attr.startsWith(SHARED_ACCESS_TOKEN_ATTRIBUTE)) {
                this.sharedAccessToken = attr.substring(SHARED_ACCESS_TOKEN_ATTRIBUTE.length());
                if (!IotHubSasToken.isExpired(this.sharedAccessToken)) continue;
                throw new SecurityException("Your SAS Token has expired");
            }
            if (attr.startsWith(MODULE_ID_ATTRIBUTE)) {
                this.moduleId = attr.substring(MODULE_ID_ATTRIBUTE.length());
                continue;
            }
            if (!attr.startsWith(GATEWAY_HOST_NAME_ATTRIBUTE)) continue;
            this.gatewayHostName = attr.substring(GATEWAY_HOST_NAME_ATTRIBUTE.length());
        }
        this.isUsingX509 = connectionString.contains(X509_ENABLED_ATTRIBUTE);
        IotHubConnectionString.validateTerms(this.hostName, this.deviceId, this.sharedAccessKey, this.sharedAccessToken, this.isUsingX509);
        this.hubName = IotHubConnectionString.parseHubName(this.hostName);
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("IotHubConnectionString object is created successfully, method name is %s ", this.logger.getMethodName());
    }

    public IotHubConnectionString(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken) throws IllegalArgumentException, URISyntaxException {
        this(hostName, deviceId, sharedAccessKey, sharedAccessToken, "");
    }

    public IotHubConnectionString(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken, String gatewayHostName) throws IllegalArgumentException, URISyntaxException {
        this.isUsingX509 = sharedAccessKey == null && sharedAccessToken == null;
        IotHubConnectionString.validateTerms(hostName, deviceId, sharedAccessKey, sharedAccessToken, this.isUsingX509);
        this.hostName = hostName;
        this.hubName = IotHubConnectionString.parseHubName(this.hostName);
        this.deviceId = deviceId;
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessToken = sharedAccessToken;
        if (this.sharedAccessToken != null && IotHubSasToken.isExpired(this.sharedAccessToken)) {
            throw new SecurityException("Your SAS Token has expired");
        }
        this.gatewayHostName = gatewayHostName;
        if (this.gatewayHostName != null && !this.gatewayHostName.isEmpty()) {
            this.hostName = gatewayHostName;
        }
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("IotHubConnectionString object is created successfully, method name is %s ", this.logger.getMethodName());
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getGatewayHostName() {
        return this.gatewayHostName;
    }

    public String getHubName() {
        return this.hubName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessToken() {
        return this.sharedAccessToken;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public boolean isUsingX509() {
        return this.isUsingX509;
    }

    public void setSharedAccessToken(String sharedAccessToken) throws IllegalArgumentException {
        if (sharedAccessToken == null || sharedAccessToken.isEmpty()) {
            throw new IllegalArgumentException("Shared access token cannot be set to null or empty");
        }
        this.sharedAccessToken = sharedAccessToken;
    }

    private static void validateTerms(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken, boolean usingX509) throws IllegalArgumentException, URISyntaxException {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("IoT Hub hostName cannot be null.");
        }
        new URI(hostName);
        IotHubConnectionString.parseHubName(hostName);
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("Device ID cannot be null.");
        }
        if (sharedAccessKey != null && sharedAccessToken != null) {
            throw new IllegalArgumentException("Either of device key or Shared Access Signature should be provided, but not both.");
        }
        if (!(usingX509 || sharedAccessKey != null && !sharedAccessKey.isEmpty() || sharedAccessToken != null && !sharedAccessToken.isEmpty())) {
            throw new IllegalArgumentException("Device key and Shared Access Signature both cannot be null unless using x509 authentication.");
        }
    }

    static String parseHubName(String hostName) throws IllegalArgumentException {
        int iotHubNameEndIdx = hostName.indexOf(".");
        if (iotHubNameEndIdx == -1) {
            String errStr = String.format("Provided hostname did not include a valid IoT Hub name as its prefix. An IoT Hub hostname has the following format: [iotHubName].[valid URI chars]", new Object[0]);
            throw new IllegalArgumentException(errStr);
        }
        return hostName.substring(0, iotHubNameEndIdx);
    }
}

