/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.FeedbackStatusCodeEnum;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.MessageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;

public class Message {
    public static final Charset DEFAULT_IOTHUB_MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private String messageId;
    private String to;
    private long expiryTime;
    private String lockToken;
    private String correlationId;
    private String userId;
    private FeedbackStatusCodeEnum ack;
    private Boolean httpBatchSerializeAsString;
    private StandardCharsets httpBatchEncoding;
    private String connectionDeviceId;
    private String connectionDeviceGenerationId;
    private String connectionAuthenticationMethod;
    private FeedbackStatusCodeEnum feedbackStatusCode;
    private String feedbackDescription;
    private String feedbackDeviceId;
    private String feedbackDeviceGenerationId;
    private MessageType messageType;
    private IotHubConnectionString iotHubConnectionString;
    private String connectionModuleId;
    private String inputName;
    private String outputName;
    private String deliveryAcknowledgement;
    private ArrayList<MessageProperty> properties;
    private byte[] body;
    private String contentType;
    private String contentEncoding;
    private ByteArrayInputStream bodyStream;
    private CustomLogger logger;

    public Message() {
        this.initialize();
    }

    public Message(ByteArrayInputStream stream) {
        this.initialize();
    }

    public Message(byte[] body) {
        if (body == null) {
            throw new IllegalArgumentException("Message body cannot be 'null'.");
        }
        this.initialize();
        this.body = body;
    }

    public Message(String body) {
        if (body == null) {
            throw new IllegalArgumentException("Message body cannot be 'null'.");
        }
        this.initialize();
        this.body = body.getBytes(DEFAULT_IOTHUB_MESSAGE_CHARSET);
        this.setContentType(DEFAULT_IOTHUB_MESSAGE_CHARSET.name());
    }

    public ByteArrayOutputStream getBodyStream() {
        return null;
    }

    public byte[] getBytes() {
        byte[] bodyClone = null;
        if (this.body != null) {
            bodyClone = Arrays.copyOf(this.body, this.body.length);
        }
        return bodyClone;
    }

    public String getProperty(String name) {
        MessageProperty messageProperty = null;
        for (MessageProperty currentMessageProperty : this.properties) {
            if (!currentMessageProperty.hasSameName(name)) continue;
            messageProperty = currentMessageProperty;
            break;
        }
        if (messageProperty == null) {
            return null;
        }
        return messageProperty.getValue();
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name cannot be 'null'.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Property value cannot be 'null'.");
        }
        MessageProperty messageProperty = null;
        for (MessageProperty currentMessageProperty : this.properties) {
            if (!currentMessageProperty.hasSameName(name)) continue;
            messageProperty = currentMessageProperty;
            break;
        }
        if (messageProperty != null) {
            this.properties.remove(messageProperty);
        }
        this.logger.LogInfo("Setting message property, method name is %s ", this.logger.getMethodName());
        this.properties.add(new MessageProperty(name, value));
    }

    public MessageProperty[] getProperties() {
        return this.properties.toArray(new MessageProperty[this.properties.size()]);
    }

    private void initialize() {
        this.lockToken = UUID.randomUUID().toString();
        this.messageId = UUID.randomUUID().toString();
        this.correlationId = UUID.randomUUID().toString();
        this.feedbackStatusCode = FeedbackStatusCodeEnum.none;
        this.ack = FeedbackStatusCodeEnum.none;
        this.properties = new ArrayList();
        this.logger = new CustomLogger(this.getClass());
    }

    public boolean isExpired() {
        boolean messageExpired;
        if (this.expiryTime == 0L) {
            messageExpired = false;
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.expiryTime) {
                this.logger.LogWarn("The message with messageid %s expired on %s, method name is %s ", this.getMessageId(), new Date(), this.logger.getMethodName());
                messageExpired = true;
            } else {
                messageExpired = false;
            }
        }
        return messageExpired;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setExpiryTime(long timeOut) {
        long currentTime = System.currentTimeMillis();
        this.expiryTime = currentTime + timeOut;
        this.logger.LogInfo("The message with messageid %s has expiry time as %s milliseconds and the message will expire on %s, method name is %s ", this.getMessageId(), timeOut, new Date(this.expiryTime), this.logger.getMethodName());
    }

    public void setAbsoluteExpiryTime(long absoluteTimeout) {
        if (absoluteTimeout < 0L) {
            throw new IllegalArgumentException("ExpiryTime may not be negative");
        }
        this.expiryTime = absoluteTimeout;
        this.logger.LogInfo("The message with messageid %s has expiry time as %s milliseconds and the message will expire on %s, method name is %s ", this.getMessageId(), absoluteTimeout, new Date(this.expiryTime), this.logger.getMethodName());
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setConnectionDeviceId(String connectionDeviceId) {
        this.connectionDeviceId = connectionDeviceId;
    }

    public void setConnectionModuleId(String connectionModuleId) {
        this.connectionModuleId = connectionModuleId;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public void setMessageType(MessageType type) {
        this.messageType = type;
    }

    public String getTo() {
        return this.to;
    }

    public String getConnectionDeviceId() {
        return this.connectionDeviceId;
    }

    public String getConnectionModuleId() {
        return this.connectionModuleId;
    }

    public String getInputName() {
        return this.inputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getDeliveryAcknowledgement() {
        return this.deliveryAcknowledgement;
    }

    public String getUserId() {
        return this.userId;
    }

    public IotHubConnectionString getIotHubConnectionString() {
        return this.iotHubConnectionString;
    }

    public void setIotHubConnectionString(IotHubConnectionString iotHubConnectionString) {
        this.iotHubConnectionString = iotHubConnectionString;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Deprecated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public final void setContentTypeFinal(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }
}

