/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class IotHubSasTokenWithRefreshAuthenticationProvider
extends IotHubSasTokenAuthenticationProvider {
    protected IotHubSasTokenWithRefreshAuthenticationProvider(String hostname, String gatewayHostName, String deviceId, String moduleId, String sharedAccessToken, int suggestedTimeToLiveSeconds, int timeBufferPercentage) {
        super(hostname, gatewayHostName, deviceId, moduleId, suggestedTimeToLiveSeconds, timeBufferPercentage);
        this.sasToken = new IotHubSasToken(hostname, deviceId, null, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    protected static String buildAudience(String hostname, String deviceId, String moduleId) throws UnsupportedEncodingException {
        if (hostname == null || deviceId == null || moduleId == null || hostname.isEmpty() || deviceId.isEmpty() || moduleId.isEmpty()) {
            throw new IllegalArgumentException("No argument can be null or empty");
        }
        return URLEncoder.encode(String.format("%s/devices/%s/modules/%s", hostname, deviceId, moduleId), "UTF-8");
    }

    @Override
    public boolean isRenewalNecessary() {
        return false;
    }

    public abstract void refreshSasToken() throws IOException, TransportException;

    @Override
    public String getRenewedSasToken(boolean proactivelyRenew) throws IOException, TransportException {
        if (this.shouldRefreshToken(proactivelyRenew)) {
            this.refreshSasToken();
        }
        return this.sasToken.toString();
    }
}

