/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.fileupload;

import com.google.gson.JsonIOException;
import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadRequestParser;
import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadResponseParser;
import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadStatusParser;
import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubMethod;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.ObjectLock;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class FileUploadTask
implements Runnable {
    private static final Charset DEFAULT_IOTHUB_MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private static final String HTTPS_URL_STRING = "https://";
    private static final String PATH_SEPARATOR_STRING = "/";
    private static final String UTF_8_STRING = "UTF-8";
    private HttpsTransportManager httpsTransportManager;
    private static CustomLogger logger;
    private String blobName;
    private InputStream inputStream;
    private long streamLength;
    private IotHubEventCallback userCallback;
    private Object userCallbackContext;
    private String correlationId;
    private URI blobURI;
    private static final ObjectLock FILE_UPLOAD_LOCK;
    private static final String THREAD_NAME = "azure-iot-sdk-FileUploadTask";

    FileUploadTask(String blobName, InputStream inputStream, long streamLength, HttpsTransportManager httpsTransportManager, IotHubEventCallback userCallback, Object userCallbackContext) throws IllegalArgumentException {
        if (blobName == null || blobName.isEmpty()) {
            throw new IllegalArgumentException("blobName is null or empty");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null or empty");
        }
        if (streamLength < 0L) {
            throw new IllegalArgumentException("streamLength is negative");
        }
        if (httpsTransportManager == null) {
            throw new IllegalArgumentException("httpsTransportManager is null");
        }
        if (userCallback == null) {
            throw new IllegalArgumentException("statusCallback is null");
        }
        this.blobName = blobName;
        this.inputStream = inputStream;
        this.streamLength = streamLength;
        this.userCallback = userCallback;
        this.userCallbackContext = userCallbackContext;
        this.httpsTransportManager = httpsTransportManager;
        logger = new CustomLogger(this.getClass());
        logger.LogInfo("HttpsFileUpload object is created successfully, method name is %s ", logger.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(THREAD_NAME);
        FileUploadStatusParser fileUploadStatusParser = null;
        IotHubStatusCode resultStatus = IotHubStatusCode.OK;
        try {
            resultStatus = this.getContainer();
        }
        catch (IOException | IllegalArgumentException | NullPointerException | URISyntaxException e) {
            logger.LogError("File upload failed to upload the stream to the blob. " + e.toString(), new Object[0]);
            resultStatus = IotHubStatusCode.ERROR;
        }
        if (resultStatus == IotHubStatusCode.OK) {
            try {
                CloudBlockBlob blob = new CloudBlockBlob(this.blobURI);
                blob.upload(this.inputStream, this.streamLength);
                fileUploadStatusParser = new FileUploadStatusParser(this.correlationId, Boolean.valueOf(true), Integer.valueOf(0), "Succeed to upload to storage.");
                resultStatus = IotHubStatusCode.OK;
            }
            catch (StorageException | IOException | IllegalArgumentException e) {
                try {
                    logger.LogError("File upload failed to upload the stream to the blob. " + e.toString(), new Object[0]);
                    resultStatus = IotHubStatusCode.ERROR;
                    fileUploadStatusParser = new FileUploadStatusParser(this.correlationId, Boolean.valueOf(false), Integer.valueOf(-1), "Failed to upload to storage.");
                    IotHubStatusCode notificationResultStatus = this.sendNotification(fileUploadStatusParser);
                    if (resultStatus == IotHubStatusCode.OK) {
                        resultStatus = notificationResultStatus;
                    }
                }
                catch (Throwable throwable) {
                    IotHubStatusCode notificationResultStatus = this.sendNotification(fileUploadStatusParser);
                    if (resultStatus == IotHubStatusCode.OK) {
                        resultStatus = notificationResultStatus;
                    }
                    throw throwable;
                }
            }
            IotHubStatusCode notificationResultStatus = this.sendNotification(fileUploadStatusParser);
            if (resultStatus == IotHubStatusCode.OK) {
                resultStatus = notificationResultStatus;
            }
        }
        this.userCallback.execute(resultStatus, this.userCallbackContext);
    }

    private void addBlobInformation(Message responseMessage) throws IllegalArgumentException, URISyntaxException, UnsupportedEncodingException {
        String json = new String(responseMessage.getBytes(), DEFAULT_IOTHUB_MESSAGE_CHARSET);
        FileUploadResponseParser fileUploadResponseParser = new FileUploadResponseParser(json);
        this.correlationId = fileUploadResponseParser.getCorrelationId();
        this.blobName = fileUploadResponseParser.getBlobName();
        String hostName = fileUploadResponseParser.getHostName();
        String containerName = fileUploadResponseParser.getContainerName();
        String sasToken = fileUploadResponseParser.getSasToken();
        String putString = HTTPS_URL_STRING + hostName + PATH_SEPARATOR_STRING + containerName + PATH_SEPARATOR_STRING + URLEncoder.encode(this.blobName, UTF_8_STRING) + sasToken;
        this.blobURI = new URI(putString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IotHubStatusCode getContainer() throws IOException, IllegalArgumentException, URISyntaxException {
        ResponseMessage responseMessage;
        FileUploadRequestParser fileUploadRequestParser = new FileUploadRequestParser(this.blobName);
        IotHubTransportMessage message = new IotHubTransportMessage(fileUploadRequestParser.toJson());
        message.setIotHubMethod(IotHubMethod.POST);
        ObjectLock objectLock = FILE_UPLOAD_LOCK;
        synchronized (objectLock) {
            this.httpsTransportManager.open();
            responseMessage = this.httpsTransportManager.sendFileUploadMessage(message);
            this.httpsTransportManager.close();
        }
        IotHubStatusCode resultStatus = responseMessage.getStatus();
        if (resultStatus == IotHubStatusCode.OK) {
            this.addBlobInformation(responseMessage);
        } else if (resultStatus == IotHubStatusCode.OK_EMPTY) {
            resultStatus = IotHubStatusCode.ERROR;
        }
        return resultStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IotHubStatusCode sendNotification(FileUploadStatusParser fileUploadStatusParser) {
        IotHubStatusCode responseStatus;
        try {
            ResponseMessage responseMessage;
            IotHubTransportMessage message = new IotHubTransportMessage(fileUploadStatusParser.toJson());
            message.setIotHubMethod(IotHubMethod.POST);
            ObjectLock objectLock = FILE_UPLOAD_LOCK;
            synchronized (objectLock) {
                this.httpsTransportManager.open();
                responseMessage = this.httpsTransportManager.sendFileUploadNotification(message);
                this.httpsTransportManager.close();
            }
            responseStatus = responseMessage.getStatus();
        }
        catch (JsonIOException | IOException | IllegalArgumentException e) {
            logger.LogError("File upload failed to report status to the iothub. " + e.toString(), new Object[0]);
            responseStatus = IotHubStatusCode.ERROR;
        }
        return responseStatus;
    }

    static {
        FILE_UPLOAD_LOCK = new ObjectLock();
    }
}

