/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubServiceException;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.net.IotHubAbandonUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubCompleteUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubEventUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubMessageUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubRejectUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubUri;
import com.microsoft.azure.sdk.iot.device.transport.IotHubListener;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportConnection;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsRequest;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;

public class HttpsIotHubConnection
implements IotHubTransportConnection {
    private static final String HTTPS_HEAD_TAG = "https://";
    private static final String HTTPS_PROPERTY_AUTHORIZATION_TAG = "authorization";
    private static final String HTTPS_PROPERTY_IOTHUB_TO_TAG = "iothub-to";
    private static final String HTTPS_PROPERTY_CONTENT_TYPE_TAG = "content-type";
    private static final String HTTPS_PROPERTY_IOTHUB_MESSAGELOCKTIMEOUT_TAG = "iothub-messagelocktimeout";
    private static final String HTTPS_PROPERTY_IF_MATCH_TAG = "if-match";
    private static final String HTTPS_PROPERTY_ETAG_TAG = "etag";
    private IotHubListener listener;
    private final Object HTTPS_CONNECTION_LOCK = new Object();
    private final DeviceClientConfig config;
    private Map<Message, String> messageToETagMap = new HashMap<Message, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpsIotHubConnection(DeviceClientConfig config) {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            this.config = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IotHubStatusCode sendMessage(Message message) throws TransportException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            HttpsSingleMessage httpsMessage = HttpsSingleMessage.parseHttpsMessage(message);
            String iotHubHostname = this.getHostName();
            String deviceId = this.config.getDeviceId();
            String moduleId = this.config.getModuleId();
            IotHubEventUri iotHubEventUri = new IotHubEventUri(iotHubHostname, deviceId, moduleId);
            URL eventUrl = this.buildUrlFromString(HTTPS_HEAD_TAG + iotHubEventUri.toString());
            HttpsRequest request = new HttpsRequest(eventUrl, HttpsMethod.POST, httpsMessage.getBody(), this.config.getProductInfo().getUserAgentString());
            for (MessageProperty property : httpsMessage.getProperties()) {
                request.setHeaderField(property.getName(), property.getValue());
            }
            if (message.getContentEncoding() != null) {
                request.setHeaderField("iothub-contentencoding", message.getContentEncoding());
            }
            if (message.getContentType() != null) {
                request.setHeaderField("iothub-contenttype", message.getContentType());
            }
            Map<String, String> systemProperties = httpsMessage.getSystemProperties();
            for (String systemProperty : systemProperties.keySet()) {
                request.setHeaderField(systemProperty, systemProperties.get(systemProperty));
            }
            request.setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, iotHubEventUri.getPath()).setHeaderField(HTTPS_PROPERTY_CONTENT_TYPE_TAG, httpsMessage.getContentType());
            HttpsResponse response = this.sendRequest(request);
            IotHubStatusCode status = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            IotHubTransportMessage transportMessage = new IotHubTransportMessage(message.getBytes(), message.getMessageType(), message.getMessageId(), message.getCorrelationId(), message.getProperties());
            if (status == IotHubStatusCode.OK || status == IotHubStatusCode.OK_EMPTY) {
                this.listener.onMessageSent(transportMessage, null);
            } else {
                this.listener.onMessageSent(transportMessage, IotHubStatusCode.getConnectionStatusException(status, ""));
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendHttpsMessage(HttpsMessage httpsMessage, HttpsMethod httpsMethod, String httpsPath, Map<String, String> additionalHeaders) throws TransportException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            String iotHubHostname = this.getHostName();
            URL messageUrl = this.buildUrlFromString(HTTPS_HEAD_TAG + iotHubHostname + httpsPath + "?" + IotHubUri.API_VERSION);
            HttpsRequest request = new HttpsRequest(messageUrl, httpsMethod, httpsMessage.getBody(), this.config.getProductInfo().getUserAgentString());
            for (MessageProperty property : httpsMessage.getProperties()) {
                request.setHeaderField(property.getName(), property.getValue());
            }
            request.setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, httpsPath).setHeaderField(HTTPS_PROPERTY_CONTENT_TYPE_TAG, httpsMessage.getContentType());
            for (String additionalHeaderKey : additionalHeaders.keySet()) {
                request.setHeaderField(additionalHeaderKey, additionalHeaders.get(additionalHeaderKey));
            }
            HttpsResponse response = this.sendRequest(request);
            IotHubStatusCode status = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            byte[] body = response.getBody();
            return new ResponseMessage(body, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IotHubTransportMessage receiveMessage() throws TransportException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            IotHubMessageUri messageUri = new IotHubMessageUri(this.getHostName(), this.config.getDeviceId(), this.config.getModuleId());
            URL messageUrl = this.buildUrlFromString(HTTPS_HEAD_TAG + messageUri.toString());
            HttpsRequest request = new HttpsRequest(messageUrl, HttpsMethod.GET, new byte[0], this.config.getProductInfo().getUserAgentString()).setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, messageUri.getPath()).setHeaderField(HTTPS_PROPERTY_IOTHUB_MESSAGELOCKTIMEOUT_TAG, Integer.toString(this.config.getMessageLockTimeoutSecs()));
            HttpsResponse response = this.sendRequest(request);
            IotHubTransportMessage transportMessage = null;
            IotHubStatusCode messageStatus = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            if (messageStatus == IotHubStatusCode.OK) {
                String messageEtag = HttpsIotHubConnection.sanitizeEtag(response.getHeaderField(HTTPS_PROPERTY_ETAG_TAG));
                HttpsSingleMessage httpsMsg = HttpsSingleMessage.parseHttpsMessage(response);
                Message message = httpsMsg.toMessage();
                transportMessage = new IotHubTransportMessage(message.getBytes(), message.getMessageType(), message.getMessageId(), message.getCorrelationId(), message.getProperties());
                transportMessage.setMessageCallback(this.config.getDeviceTelemetryMessageCallback(message.getInputName()));
                transportMessage.setMessageCallbackContext(this.config.getDeviceTelemetryMessageContext(message.getInputName()));
                this.messageToETagMap.put(transportMessage, messageEtag);
            }
            return transportMessage;
        }
    }

    private static String sanitizeEtag(String dirtyEtag) {
        return dirtyEtag.replace("\"", "");
    }

    @Override
    public void open(Queue<DeviceClientConfig> deviceClientConfigs, ScheduledExecutorService scheduledExecutorService) {
    }

    @Override
    public void setListener(IotHubListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listener = listener;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessageResult(Message message, IotHubMessageResult result) throws TransportException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            HttpsRequest request;
            String resultPath;
            String messageEtag = this.messageToETagMap.get(message);
            if (messageEtag == null) {
                throw new IllegalStateException("Cannot send a message result before a message is received or if the result was already sent");
            }
            String iotHubHostname = this.getHostName();
            String deviceId = this.config.getDeviceId();
            String resultUri = HTTPS_HEAD_TAG;
            switch (result) {
                case COMPLETE: {
                    IotHubCompleteUri completeUri = new IotHubCompleteUri(iotHubHostname, deviceId, messageEtag, this.config.getModuleId());
                    resultUri = resultUri + completeUri.toString();
                    resultPath = completeUri.getPath();
                    URL resultUrl = this.buildUrlFromString(resultUri);
                    request = new HttpsRequest(resultUrl, HttpsMethod.DELETE, new byte[0], this.config.getProductInfo().getUserAgentString());
                    break;
                }
                case ABANDON: {
                    IotHubAbandonUri abandonUri = new IotHubAbandonUri(iotHubHostname, deviceId, messageEtag, this.config.getModuleId());
                    resultUri = resultUri + abandonUri.toString();
                    resultPath = abandonUri.getPath();
                    URL resultUrl = this.buildUrlFromString(resultUri);
                    request = new HttpsRequest(resultUrl, HttpsMethod.POST, new byte[1], this.config.getProductInfo().getUserAgentString());
                    break;
                }
                case REJECT: {
                    IotHubRejectUri rejectUri = new IotHubRejectUri(iotHubHostname, deviceId, messageEtag, this.config.getModuleId());
                    resultUri = resultUri + rejectUri.toString();
                    resultPath = rejectUri.getPath();
                    URL resultUrl = this.buildUrlFromString(resultUri);
                    request = new HttpsRequest(resultUrl, HttpsMethod.DELETE, new byte[0], this.config.getProductInfo().getUserAgentString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid message result specified.");
                }
            }
            request.setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, resultPath).setHeaderField(HTTPS_PROPERTY_IF_MATCH_TAG, messageEtag);
            HttpsResponse response = this.sendRequest(request);
            IotHubStatusCode resultStatus = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            if (resultStatus != IotHubStatusCode.OK_EMPTY && resultStatus != IotHubStatusCode.OK) {
                String errMsg = String.format("Sending message result failed with status %s.%n", resultStatus.name());
                throw new IotHubServiceException(errMsg);
            }
            this.messageToETagMap.remove(message);
            return true;
        }
    }

    @Override
    public String getConnectionId() {
        return "";
    }

    private HttpsResponse sendRequest(HttpsRequest request) throws TransportException {
        request.setReadTimeoutMillis(this.config.getReadTimeoutMillis());
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
            request.setHeaderField(HTTPS_PROPERTY_AUTHORIZATION_TAG, this.getSasToken());
        }
        request.setSSLContext(this.getSSLContext());
        HttpsResponse response = request.send();
        return response;
    }

    private URL buildUrlFromString(String url) throws TransportException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new TransportException("Could not build HTTP url", e);
        }
    }

    private String getSasToken() throws TransportException {
        try {
            return this.config.getSasTokenAuthentication().getRenewedSasToken(false);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private SSLContext getSSLContext() throws TransportException {
        try {
            return this.config.getAuthenticationProvider().getSSLContext();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private String getHostName() {
        String hostname = this.config.getGatewayHostname();
        if (hostname == null || hostname.isEmpty()) {
            hostname = this.config.getIotHubHostname();
        }
        return hostname;
    }
}

