/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.deps.auth.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.deps.util.Base64;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderTpm;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.net.ssl.SSLContext;

public class IotHubSasTokenHardwareAuthenticationProvider
extends IotHubSasTokenAuthenticationProvider {
    private static final String TOKEN_SCOPE_FORMAT = "%s/devices/%s";
    private static final String SASTOKEN_FORMAT = "SharedAccessSignature sr=%s&sig=%s&se=%s";
    protected SecurityProviderTpm securityProvider;

    public IotHubSasTokenHardwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, SecurityProvider securityProvider) throws IOException {
        super(hostname, gatewayHostname, deviceId, moduleId);
        try {
            if (!(securityProvider instanceof SecurityProviderTpm)) {
                throw new IllegalArgumentException("The provided security provided must be an instance of SecurityProviderTpm");
            }
            this.securityProvider = (SecurityProviderTpm)securityProvider;
            this.sasToken = new IotHubSasToken(hostname, deviceId, null, this.generateSasTokenSignatureFromSecurityProvider(this.tokenValidSecs), moduleId, 0L);
            this.iotHubSSLContext = new IotHubSSLContext(securityProvider.getSSLContext());
            this.sslContextNeedsUpdate = false;
        }
        catch (SecurityProviderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getRenewedSasToken(boolean proactivelyRenew) throws IOException {
        if (this.shouldRefreshToken(proactivelyRenew)) {
            String sasTokenString = this.generateSasTokenSignatureFromSecurityProvider(this.tokenValidSecs);
            this.sasToken = new IotHubSasToken(this.hostname, this.deviceId, null, sasTokenString, this.moduleId, 0L);
        }
        return this.sasToken.toString();
    }

    @Override
    public boolean canRefreshToken() {
        return true;
    }

    @Override
    public SSLContext getSSLContext() throws IOException {
        return this.iotHubSSLContext.getSSLContext();
    }

    @Override
    public void setPathToIotHubTrustedCert(String pathToCertificate) {
        throw new UnsupportedOperationException("Cannot change the trusted certificate when using security provider for authentication.");
    }

    @Override
    public void setIotHubTrustedCert(String certificate) {
        throw new UnsupportedOperationException("Cannot change the trusted certificate when using security provider for authentication.");
    }

    @Override
    public boolean isRenewalNecessary() {
        return false;
    }

    private String generateSasTokenSignatureFromSecurityProvider(long secondsToLive) throws IOException {
        try {
            String tokenScope = String.format(TOKEN_SCOPE_FORMAT, this.hostname, this.deviceId);
            String encodedTokenScope = URLEncoder.encode(tokenScope, ENCODING_FORMAT_NAME);
            if (encodedTokenScope == null || encodedTokenScope.isEmpty()) {
                throw new IOException("Could not construct token scope");
            }
            Long expiryTimeUTC = System.currentTimeMillis() / 1000L + secondsToLive;
            byte[] token = this.securityProvider.signWithIdentity(encodedTokenScope.concat("\n" + String.valueOf(expiryTimeUTC)).getBytes());
            if (token == null || token.length == 0) {
                throw new IOException("Security provider could not sign data successfully");
            }
            byte[] base64Signature = Base64.encodeBase64Local((byte[])token);
            String base64UrlEncodedSignature = URLEncoder.encode(new String(base64Signature), ENCODING_FORMAT_NAME);
            return String.format(SASTOKEN_FORMAT, encodedTokenScope, base64UrlEncodedSignature, expiryTimeUTC);
        }
        catch (SecurityProviderException | UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }
}

