/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.net;

import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class IotHubUri {
    private static final String PATH_FORMAT = "/devices/%s%s";
    private static final String PATH_FORMAT_WITH_MODULEID = "/devices/%s/modules/%s/%s";
    public static final String API_VERSION = "api-version=" + TransportUtils.IOTHUB_API_VERSION;
    private static final Charset IOTHUB_URL_ENCODING_CHARSET = StandardCharsets.UTF_8;
    private String hostname;
    private String path;
    private String uri;

    public IotHubUri(String iotHubHostname, String deviceId, String iotHubMethodPath, Map<String, String> queryParams, String moduleId) {
        this.hostname = iotHubHostname;
        String rawPath = moduleId == null || moduleId.isEmpty() ? String.format(PATH_FORMAT, deviceId, iotHubMethodPath) : String.format(PATH_FORMAT_WITH_MODULEID, deviceId, moduleId, iotHubMethodPath);
        this.path = IotHubUri.urlEncodePath(rawPath);
        StringBuilder uriBuilder = new StringBuilder(this.hostname);
        uriBuilder.append(this.path);
        uriBuilder.append("?");
        uriBuilder.append(API_VERSION);
        if (queryParams != null) {
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                uriBuilder.append("&");
                IotHubUri.appendQueryParam(uriBuilder, param.getKey(), param.getValue());
            }
        }
        this.uri = uriBuilder.toString();
    }

    public IotHubUri(String iotHubHostname, String deviceId, String iotHubMethodPath, String moduleId) {
        this(iotHubHostname, deviceId, iotHubMethodPath, null, moduleId);
    }

    public String toString() {
        return this.uri;
    }

    public String toStringWithoutApiVersion() {
        return this.hostname + this.path;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPath() {
        return this.path;
    }

    public static String getResourceUri(String iotHubHostname, String deviceId, String moduleId) {
        IotHubUri iotHubUri = new IotHubUri(iotHubHostname, deviceId, "", moduleId);
        return iotHubUri.getHostname() + iotHubUri.getPath();
    }

    private static String urlEncodePath(String path) {
        String[] pathSubDirs = path.split("/");
        StringBuilder urlEncodedPathBuilder = new StringBuilder();
        try {
            for (String subDir : pathSubDirs) {
                if (subDir.length() <= 0) continue;
                String urlEncodedSubDir = URLEncoder.encode(subDir, IOTHUB_URL_ENCODING_CHARSET.name());
                urlEncodedPathBuilder.append("/");
                urlEncodedPathBuilder.append(urlEncodedSubDir);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return urlEncodedPathBuilder.toString();
    }

    private static void appendQueryParam(StringBuilder uriBuilder, String name, String value) {
        try {
            String urlEncodedName = URLEncoder.encode(name, IOTHUB_URL_ENCODING_CHARSET.name());
            String urlEncodedValue = URLEncoder.encode(value, IOTHUB_URL_ENCODING_CHARSET.name());
            uriBuilder.append(urlEncodedName);
            uriBuilder.append("=");
            uriBuilder.append(urlEncodedValue);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getApiVersionString() {
        return API_VERSION;
    }

    protected IotHubUri() {
    }
}

