/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthentication;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthenticationCBSTokenRenewalTask;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthenticationState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceMethods;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceTelemetry;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceTwin;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;

public class AmqpsSessionDeviceOperation {
    private final DeviceClientConfig deviceClientConfig;
    private AmqpsDeviceAuthenticationState amqpsAuthenticatorState = AmqpsDeviceAuthenticationState.UNKNOWN;
    private final AmqpsDeviceAuthentication amqpsDeviceAuthentication;
    private ArrayList<AmqpsDeviceOperations> amqpsDeviceOperationsList = new ArrayList();
    private long nextTag = 0L;
    private Integer openLock = new Integer(1);
    private long tokenRenewalPeriodInMilliseconds = 4000L;
    private ScheduledExecutorService taskSchedulerTokenRenewal;
    private AmqpsDeviceAuthenticationCBSTokenRenewalTask tokenRenewalTask = null;
    private static final int MAX_WAIT_TO_AUTHENTICATE = 10000;
    private static final double PERCENTAGE_FACTOR = 0.75;
    private static final int SEC_IN_MILLISEC = 1000;
    private final CountDownLatch authenticationLatch = new CountDownLatch(1);
    private List<UUID> cbsCorrelationIdList = Collections.synchronizedList(new ArrayList());
    private CustomLogger logger;

    public AmqpsSessionDeviceOperation(DeviceClientConfig deviceClientConfig, AmqpsDeviceAuthentication amqpsDeviceAuthentication) throws IllegalArgumentException {
        if (deviceClientConfig == null) {
            throw new IllegalArgumentException("deviceClientConfig cannot be null.");
        }
        if (amqpsDeviceAuthentication == null) {
            throw new IllegalArgumentException("amqpsDeviceAuthentication cannot be null.");
        }
        this.deviceClientConfig = deviceClientConfig;
        this.amqpsDeviceAuthentication = amqpsDeviceAuthentication;
        this.amqpsDeviceOperationsList.add(new AmqpsDeviceTelemetry(this.deviceClientConfig));
        this.amqpsDeviceOperationsList.add(new AmqpsDeviceMethods(this.deviceClientConfig));
        this.amqpsDeviceOperationsList.add(new AmqpsDeviceTwin(this.deviceClientConfig));
        this.logger = new CustomLogger(this.getClass());
        if (this.deviceClientConfig.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
            this.amqpsAuthenticatorState = AmqpsDeviceAuthenticationState.NOT_AUTHENTICATED;
            this.tokenRenewalTask = new AmqpsDeviceAuthenticationCBSTokenRenewalTask(this);
            this.scheduleRenewalThread();
        } else {
            this.amqpsAuthenticatorState = AmqpsDeviceAuthenticationState.AUTHENTICATED;
        }
    }

    public void close() {
        this.shutDownScheduler();
        this.closeLinks();
        if (this.deviceClientConfig.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
            this.amqpsAuthenticatorState = AmqpsDeviceAuthenticationState.NOT_AUTHENTICATED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.deviceClientConfig.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
            UUID correlationId = UUID.randomUUID();
            List<UUID> list = this.cbsCorrelationIdList;
            synchronized (list) {
                this.cbsCorrelationIdList.add(correlationId);
            }
            this.amqpsDeviceAuthentication.authenticate(this.deviceClientConfig, correlationId);
            this.amqpsAuthenticatorState = AmqpsDeviceAuthenticationState.AUTHENTICATING;
            try {
                this.authenticationLatch.await(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.cbsCorrelationIdList.remove(correlationId);
                throw new TransportException("Waited too long for the authentication message reply.");
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    public void renewToken() throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.deviceClientConfig.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && this.amqpsAuthenticatorState == AmqpsDeviceAuthenticationState.AUTHENTICATED) {
            if (this.deviceClientConfig.getSasTokenAuthentication().isRenewalNecessary()) {
                this.logger.LogDebug("Sas token cannot be renewed automatically, so amqp connection will be unauthorized soon, method: %s", this.logger.getMethodName());
            } else {
                this.authenticate();
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    public AmqpsDeviceAuthenticationState getAmqpsAuthenticatorState() {
        return this.amqpsAuthenticatorState;
    }

    public Boolean operationLinksOpened() {
        Boolean allLinksOpened = true;
        for (int i = 0; i < this.amqpsDeviceOperationsList.size(); ++i) {
            if (this.amqpsDeviceOperationsList.get(i).operationLinksOpened().booleanValue()) continue;
            allLinksOpened = false;
            break;
        }
        return allLinksOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openLinks(Session session) throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (session != null && this.amqpsAuthenticatorState == AmqpsDeviceAuthenticationState.AUTHENTICATED) {
            for (int i = 0; i < this.amqpsDeviceOperationsList.size(); ++i) {
                Integer n = this.openLock;
                synchronized (n) {
                    this.amqpsDeviceOperationsList.get(i).openLinks(session);
                    continue;
                }
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    void closeLinks() {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        for (int i = 0; i < this.amqpsDeviceOperationsList.size(); ++i) {
            this.amqpsDeviceOperationsList.get(i).closeLinks();
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    void initLink(Link link) throws TransportException, IllegalArgumentException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (link != null && this.amqpsAuthenticatorState == AmqpsDeviceAuthenticationState.AUTHENTICATED) {
            for (int i = 0; i < this.amqpsDeviceOperationsList.size(); ++i) {
                this.amqpsDeviceOperationsList.get(i).initLink(link);
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    Integer sendMessage(org.apache.qpid.proton.message.Message message, MessageType messageType, String deviceId) throws IllegalStateException, IllegalArgumentException {
        if (this.amqpsAuthenticatorState == AmqpsDeviceAuthenticationState.AUTHENTICATED) {
            if (this.deviceClientConfig.getDeviceId().equals(deviceId)) {
                int length;
                byte[] msgData = new byte[1024];
                while (true) {
                    try {
                        length = message.encode(msgData, 0, msgData.length);
                    }
                    catch (BufferOverflowException e) {
                        msgData = new byte[msgData.length * 2];
                        continue;
                    }
                    break;
                }
                byte[] deliveryTag = String.valueOf(this.nextTag++).getBytes();
                return this.sendMessageAndGetDeliveryHash(messageType, msgData, 0, length, deliveryTag);
            }
            return -1;
        }
        return -1;
    }

    private Integer sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        Integer deliveryHash = -1;
        for (int i = 0; i < this.amqpsDeviceOperationsList.size(); ++i) {
            AmqpsSendReturnValue amqpsSendReturnValue = null;
            amqpsSendReturnValue = this.amqpsDeviceOperationsList.get(i).sendMessageAndGetDeliveryHash(messageType, msgData, 0, length, deliveryTag);
            if (!amqpsSendReturnValue.isDeliverySuccessful()) continue;
            return amqpsSendReturnValue.getDeliveryHash();
        }
        return deliveryHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, TransportException {
        AmqpsMessage amqpsMessage = null;
        if (this.amqpsAuthenticatorState == AmqpsDeviceAuthenticationState.AUTHENTICATING) {
            amqpsMessage = this.amqpsDeviceAuthentication.getMessageFromReceiverLink(linkName);
            if (amqpsMessage != null) {
                List<UUID> list = this.cbsCorrelationIdList;
                synchronized (list) {
                    UUID uuidFound = null;
                    for (UUID correlationId : this.cbsCorrelationIdList) {
                        if (!this.amqpsDeviceAuthentication.authenticationMessageReceived(amqpsMessage, correlationId).booleanValue()) continue;
                        this.amqpsAuthenticatorState = AmqpsDeviceAuthenticationState.AUTHENTICATED;
                        this.authenticationLatch.countDown();
                        uuidFound = correlationId;
                        break;
                    }
                    if (uuidFound != null) {
                        this.cbsCorrelationIdList.remove(uuidFound);
                    }
                }
                return amqpsMessage;
            }
        } else {
            for (int i = 0; i < this.amqpsDeviceOperationsList.size() && (amqpsMessage = this.amqpsDeviceOperationsList.get(i).getMessageFromReceiverLink(linkName)) == null; ++i) {
            }
        }
        return amqpsMessage;
    }

    Boolean isLinkFound(String linkName) {
        if (this.amqpsAuthenticatorState == AmqpsDeviceAuthenticationState.AUTHENTICATED) {
            for (int i = 0; i < this.amqpsDeviceOperationsList.size(); ++i) {
                if (!this.amqpsDeviceOperationsList.get(i).isLinkFound(linkName).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    AmqpsConvertToProtonReturnValue convertToProton(Message message) throws TransportException {
        AmqpsConvertToProtonReturnValue amqpsConvertToProtonReturnValue = null;
        if (this.amqpsDeviceOperationsList != null) {
            for (int i = 0; i < this.amqpsDeviceOperationsList.size() && (amqpsConvertToProtonReturnValue = this.amqpsDeviceOperationsList.get(i).convertToProton(message)) == null; ++i) {
            }
        }
        return amqpsConvertToProtonReturnValue;
    }

    AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws TransportException {
        AmqpsConvertFromProtonReturnValue amqpsHandleMessageReturnValue = null;
        if (this.amqpsDeviceOperationsList != null) {
            for (int i = 0; i < this.amqpsDeviceOperationsList.size() && (amqpsHandleMessageReturnValue = this.amqpsDeviceOperationsList.get(i).convertFromProton(amqpsMessage, deviceClientConfig)) == null; ++i) {
            }
        }
        return amqpsHandleMessageReturnValue;
    }

    private void scheduleRenewalThread() {
        long renewalPeriod = this.calculateRenewalTimeInMilliseconds(this.deviceClientConfig.getSasTokenAuthentication().getTokenValidSecs());
        if (renewalPeriod > 0L) {
            this.tokenRenewalPeriodInMilliseconds = renewalPeriod;
            this.shutDownScheduler();
            this.taskSchedulerTokenRenewal = Executors.newScheduledThreadPool(1);
            this.taskSchedulerTokenRenewal.scheduleAtFixedRate(this.tokenRenewalTask, 0L, this.tokenRenewalPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    private void shutDownScheduler() {
        if (this.taskSchedulerTokenRenewal != null) {
            this.taskSchedulerTokenRenewal.shutdown();
            try {
                if (!this.taskSchedulerTokenRenewal.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.taskSchedulerTokenRenewal.shutdownNow();
                    if (!this.taskSchedulerTokenRenewal.awaitTermination(10L, TimeUnit.SECONDS)) {
                        System.err.println("taskSchedulerTokenRenewal did not terminate correctly");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.taskSchedulerTokenRenewal.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private long calculateRenewalTimeInMilliseconds(long validInSecs) throws IllegalArgumentException {
        if (validInSecs < 0L) {
            throw new IllegalArgumentException("validInSecs cannot be less than 0.");
        }
        return (long)((double)validInSecs * 0.75 * 1000.0);
    }
}

