/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttConnection;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.TopicParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class MqttDeviceMethod
extends Mqtt {
    private String subscribeTopic = "$iothub/methods/POST/#";
    private String responseTopic = "$iothub/methods/res";
    private final Map<String, DeviceOperations> requestMap = new HashMap<String, DeviceOperations>();
    private boolean isStarted = false;
    private final CustomLogger logger = new CustomLogger(this.getClass());
    private final String POUND = "#";
    private final String BACKSLASH = "/";
    private final String QUESTION = "?";
    private final String METHOD = "$iothub/methods/";
    private final String POST = "$iothub/methods/POST";
    private final String RES = "$iothub/methods/res";
    private final String REQ_ID = "?$rid=";
    private final int POST_TOKEN = 2;
    private final int METHOD_TOKEN = 3;
    private final int REQID_TOKEN = 4;

    public MqttDeviceMethod(MqttConnection mqttConnection, String connectionId) throws TransportException {
        super(mqttConnection, null, null, connectionId);
    }

    public void start() {
        if (!this.isStarted) {
            this.isStarted = true;
        }
    }

    public void stop() {
        this.isStarted = false;
        if (!this.requestMap.isEmpty()) {
            this.logger.LogInfo("Pending %d responses to be sent to IotHub yet unsubscribed %s", this.requestMap.size(), this.logger.getMethodName());
        }
    }

    public void send(IotHubTransportMessage message) throws TransportException, IllegalArgumentException {
        if (message == null || message.getBytes() == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        if (!this.isStarted) {
            this.throwMethodsTransportException("Start device method before using send");
        }
        if (message.getMessageType() != MessageType.DEVICE_METHODS) {
            return;
        }
        switch (message.getDeviceOperationType()) {
            case DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST: {
                this.subscribe(this.subscribeTopic);
                break;
            }
            case DEVICE_OPERATION_METHOD_SEND_RESPONSE: {
                if (message.getRequestId() == null || message.getRequestId().isEmpty()) {
                    throw new IllegalArgumentException("Request id cannot be null or empty");
                }
                if (this.requestMap.containsKey(message.getRequestId())) {
                    switch (this.requestMap.remove(message.getRequestId())) {
                        case DEVICE_OPERATION_METHOD_RECEIVE_REQUEST: {
                            break;
                        }
                        default: {
                            this.throwMethodsTransportException("Mismatched request and response operation");
                            break;
                        }
                    }
                } else {
                    this.throwMethodsTransportException("Sending a response for the method that was never invoked");
                }
                String topic = this.responseTopic + "/" + message.getStatus() + "/" + "?$rid=" + message.getRequestId();
                this.publish(topic, message);
                break;
            }
            default: {
                this.throwMethodsTransportException("Mismatched device method operation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IotHubTransportMessage receive() throws TransportException {
        Object object = this.incomingLock;
        synchronized (object) {
            String topic;
            IotHubTransportMessage message = null;
            Pair<String, byte[]> messagePair = this.peekMessage();
            if (messagePair != null && (topic = (String)messagePair.getKey()) != null && topic.length() > 0) {
                byte[] data = (byte[])messagePair.getValue();
                if (topic.length() > "$iothub/methods/".length() && topic.startsWith("$iothub/methods/") && topic.length() > "$iothub/methods/POST".length() && topic.startsWith("$iothub/methods/POST")) {
                    this.allReceivedMessages.poll();
                    TopicParser topicParser = new TopicParser(topic);
                    message = data != null && data.length > 0 ? new IotHubTransportMessage(data, MessageType.DEVICE_METHODS) : new IotHubTransportMessage(new byte[0], MessageType.DEVICE_METHODS);
                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                    String methodName = topicParser.getMethodName(3);
                    message.setMethodName(methodName);
                    String reqId = topicParser.getRequestId(4);
                    if (reqId != null) {
                        message.setRequestId(reqId);
                        message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
                        this.requestMap.put(reqId, DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
                    } else {
                        this.throwMethodsTransportException("Request ID cannot be null");
                    }
                }
            }
            return message;
        }
    }

    private void throwMethodsTransportException(String message) throws TransportException {
        TransportException transportException = new TransportException(message);
        transportException.setIotHubService(TransportException.IotHubService.METHODS);
        throw transportException;
    }

    private void throwMethodsTransportException(Exception e) throws TransportException {
        TransportException transportException = new TransportException(e);
        transportException.setIotHubService(TransportException.IotHubService.METHODS);
        throw transportException;
    }
}

