/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeReason;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.exceptions.DeviceClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubReceiveTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubSendTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class DeviceIO {
    private long sendPeriodInMilliseconds;
    private long receivePeriodInMilliseconds;
    private CustomLogger logger;
    private IotHubTransport transport;
    private DeviceClientConfig config;
    private IotHubSendTask sendTask = null;
    private IotHubReceiveTask receiveTask = null;
    private IotHubClientProtocol protocol = null;
    private ScheduledExecutorService taskScheduler;
    private IotHubClientState state;
    private List<DeviceClientConfig> deviceClientConfigs = new LinkedList<DeviceClientConfig>();

    DeviceIO(DeviceClientConfig config, long sendPeriodInMilliseconds, long receivePeriodInMilliseconds) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null.");
        }
        this.deviceClientConfigs.add(config);
        this.config = config;
        this.protocol = this.config.getProtocol();
        this.sendPeriodInMilliseconds = sendPeriodInMilliseconds;
        this.receivePeriodInMilliseconds = receivePeriodInMilliseconds;
        this.state = IotHubClientState.CLOSED;
        if (this.protocol == IotHubClientProtocol.AMQPS_WS || this.protocol == IotHubClientProtocol.MQTT_WS) {
            this.config.setUseWebsocket(true);
        }
        this.transport = new IotHubTransport(config);
        this.sendPeriodInMilliseconds = sendPeriodInMilliseconds;
        this.receivePeriodInMilliseconds = receivePeriodInMilliseconds;
        this.state = IotHubClientState.CLOSED;
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceIO object is created successfully, method name is %s ", this.logger.getMethodName());
    }

    void open() throws IOException {
        if (this.state == IotHubClientState.OPEN) {
            return;
        }
        try {
            this.transport.open(this.deviceClientConfigs);
        }
        catch (DeviceClientException e) {
            throw new IOException("Could not open the connection", e);
        }
        this.commonOpenSetup();
    }

    void addClient(DeviceClientConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.deviceClientConfigs.add(config);
    }

    private void commonOpenSetup() {
        this.sendTask = new IotHubSendTask(this.transport);
        this.receiveTask = new IotHubReceiveTask(this.transport);
        this.taskScheduler = Executors.newScheduledThreadPool(2);
        this.taskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.state = IotHubClientState.OPEN;
    }

    public void close() throws IOException {
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
        try {
            this.transport.close(IotHubConnectionStatusChangeReason.CLIENT_CLOSE, null);
        }
        catch (DeviceClientException e) {
            this.state = IotHubClientState.CLOSED;
            throw new IOException(e);
        }
        this.state = IotHubClientState.CLOSED;
    }

    public void multiplexClose() throws IOException {
        this.close();
    }

    public synchronized void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext, String deviceId) {
        if (this.state == IotHubClientState.CLOSED) {
            throw new IllegalStateException("Cannot send event from an IoT Hub client that is closed.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Cannot send message 'null'.");
        }
        if (deviceId != null) {
            message.setConnectionDeviceId(deviceId);
        }
        this.logger.LogInfo("Message with messageid %s along with callback and callbackcontext is added to the queue, method name is %s ", message.getMessageId(), this.logger.getMethodName());
        this.transport.addMessage(message, callback, callbackContext);
    }

    public long getReceivePeriodInMilliseconds() {
        return this.receivePeriodInMilliseconds;
    }

    public void setReceivePeriodInMilliseconds(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("receive interval can not be zero or negative");
        }
        this.receivePeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.taskScheduler != null) {
            if (this.receiveTask == null) {
                throw new IOException("transport receive task not set");
            }
            this.taskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public long getSendPeriodInMilliseconds() {
        return this.sendPeriodInMilliseconds;
    }

    public void setSendPeriodInMilliseconds(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("send interval can not be zero or negative");
        }
        this.sendPeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.taskScheduler != null) {
            if (this.sendTask == null) {
                throw new IOException("transport send task not set");
            }
            this.taskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public IotHubClientProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isOpen() {
        return this.state == IotHubClientState.OPEN;
    }

    public boolean isEmpty() {
        return this.transport.isEmpty();
    }

    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) {
        this.transport.registerConnectionStateCallback(callback, callbackContext);
    }

    public void registerConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback statusChangeCallback, Object callbackContext) {
        this.transport.registerConnectionStatusChangeCallback(statusChangeCallback, callbackContext);
    }

    protected static enum IotHubClientState {
        OPEN,
        CLOSED;

    }
}

