/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class IotHubSasTokenAuthenticationProvider
extends IotHubAuthenticationProvider {
    protected long tokenValidSecs = 3600L;
    protected int timeBufferPercentage = 85;
    protected static final long MILLISECONDS_PER_SECOND = 1000L;
    protected static final long MINIMUM_EXPIRATION_TIME_OFFSET = 1L;
    protected static final String ENCODING_FORMAT_NAME = StandardCharsets.UTF_8.displayName();
    protected IotHubSasToken sasToken;

    public abstract boolean canRefreshToken();

    public abstract String getRenewedSasToken(boolean var1, boolean var2) throws IOException, TransportException;

    public IotHubSasTokenAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId) {
        super(hostname, gatewayHostname, deviceId, moduleId);
    }

    public IotHubSasTokenAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, long tokenValidSecs, int timeBufferPercentage) {
        super(hostname, gatewayHostname, deviceId, moduleId);
        this.setTokenValidSecs(tokenValidSecs);
        if (timeBufferPercentage < 1 || timeBufferPercentage > 100) {
            throw new IllegalArgumentException("Time buffer percentage must be a percentage between 1 and 100");
        }
        this.timeBufferPercentage = timeBufferPercentage;
    }

    public void setTokenValidSecs(long tokenValidSecs) {
        if (tokenValidSecs < 1L) {
            throw new IllegalArgumentException("tokens must live for more than 1 second");
        }
        this.tokenValidSecs = tokenValidSecs;
    }

    public boolean isRenewalNecessary() {
        return this.sasToken != null && this.sasToken.isExpired();
    }

    public boolean shouldRefreshToken(boolean proactivelyRenew) {
        long currentTimeSeconds;
        long expiryTimeSeconds;
        long tokenStartTime;
        long bufferExpiryTime;
        if (this.sasToken.isExpired()) {
            return true;
        }
        return proactivelyRenew && (bufferExpiryTime = this.tokenValidSecs * (long)this.timeBufferPercentage / 100L + (tokenStartTime = (expiryTimeSeconds = IotHubSasToken.getExpiryTimeFromToken(this.sasToken.toString()).longValue()) - this.tokenValidSecs)) < (currentTimeSeconds = System.currentTimeMillis() / 1000L);
    }

    public long getTokenValidSecs() {
        return this.tokenValidSecs;
    }

    long getExpiryTimeInSeconds() {
        return System.currentTimeMillis() / 1000L + this.tokenValidSecs + 1L;
    }
}

