/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.SignatureHelper;

public final class Signature {
    private final String sig;

    public Signature(String resourceUri, long expiryTime, String deviceKey) {
        byte[] rawSig = SignatureHelper.buildRawSignature(resourceUri, expiryTime);
        byte[] decodedDeviceKey = SignatureHelper.decodeDeviceKeyBase64(deviceKey);
        byte[] encryptedSig = SignatureHelper.encryptSignatureHmacSha256(rawSig, decodedDeviceKey);
        byte[] encryptedSigBase64 = SignatureHelper.encodeSignatureBase64(encryptedSig);
        String utf8Sig = SignatureHelper.encodeSignatureUtf8(encryptedSigBase64);
        this.sig = SignatureHelper.encodeSignatureWebSafe(utf8Sig);
    }

    public String toString() {
        return this.sig;
    }
}

