/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.ObjectLock;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthentication;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthenticationCBS;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthenticationCBSSendTask;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthenticationX509;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSessionDeviceOperation;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;

public class AmqpsSessionManager {
    private final DeviceClientConfig deviceClientConfig;
    protected Session session = null;
    private AmqpsDeviceAuthentication amqpsDeviceAuthentication;
    private ArrayList<AmqpsSessionDeviceOperation> amqpsDeviceSessionList = new ArrayList();
    private long SEND_PERIOD_MILLISECONDS = 300L;
    private ScheduledExecutorService taskSchedulerCBSSend;
    private AmqpsDeviceAuthenticationCBSSendTask cbsAuthSendTask = null;
    private static final int MAX_WAIT_TO_AUTHENTICATE_MS = 10000;
    private final ObjectLock openLinksLock = new ObjectLock();
    private CustomLogger logger;

    public AmqpsSessionManager(DeviceClientConfig deviceClientConfig, ScheduledExecutorService scheduledExecutorService) throws TransportException {
        if (deviceClientConfig == null) {
            throw new IllegalArgumentException("deviceClientConfig cannot be null.");
        }
        if (scheduledExecutorService == null) {
            throw new IllegalArgumentException("scheduledExecutorService cannot be null.");
        }
        this.logger = new CustomLogger(this.getClass());
        this.deviceClientConfig = deviceClientConfig;
        switch (this.deviceClientConfig.getAuthenticationType()) {
            case SAS_TOKEN: {
                this.amqpsDeviceAuthentication = new AmqpsDeviceAuthenticationCBS(this.deviceClientConfig);
                this.cbsAuthSendTask = new AmqpsDeviceAuthenticationCBSSendTask((AmqpsDeviceAuthenticationCBS)this.amqpsDeviceAuthentication);
                this.taskSchedulerCBSSend = scheduledExecutorService;
                this.taskSchedulerCBSSend.scheduleAtFixedRate(this.cbsAuthSendTask, 0L, this.SEND_PERIOD_MILLISECONDS, TimeUnit.MILLISECONDS);
                break;
            }
            case X509_CERTIFICATE: {
                this.amqpsDeviceAuthentication = new AmqpsDeviceAuthenticationX509(this.deviceClientConfig);
            }
        }
        this.addDeviceOperationSession(this.deviceClientConfig);
    }

    final void addDeviceOperationSession(DeviceClientConfig deviceClientConfig) throws TransportException {
        if (deviceClientConfig == null) {
            throw new IllegalArgumentException("deviceClientConfig cannot be null.");
        }
        AmqpsSessionDeviceOperation amqpsSessionDeviceOperation = new AmqpsSessionDeviceOperation(deviceClientConfig, this.amqpsDeviceAuthentication);
        this.amqpsDeviceSessionList.add(amqpsSessionDeviceOperation);
    }

    void closeNow() {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        this.shutDownScheduler();
        for (int i = 0; i < this.amqpsDeviceSessionList.size(); ++i) {
            if (this.amqpsDeviceSessionList.get(i) == null) continue;
            this.amqpsDeviceSessionList.get(i).close();
        }
        this.amqpsDeviceAuthentication.closeLinks();
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    public void authenticate() throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.deviceClientConfig.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && this.isAuthenticationOpened().booleanValue()) {
            for (int i = 0; i < this.amqpsDeviceSessionList.size(); ++i) {
                if (this.amqpsDeviceSessionList.get(i) == null) continue;
                this.amqpsDeviceSessionList.get(i).authenticate();
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDeviceOperationLinks(MessageType msgType) throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.session != null) {
            for (int i = 0; i < this.amqpsDeviceSessionList.size(); ++i) {
                if (this.amqpsDeviceSessionList.get(i) == null || !this.amqpsDeviceSessionList.get(i).openLinks(this.session, msgType)) continue;
                ObjectLock objectLock = this.openLinksLock;
                synchronized (objectLock) {
                    try {
                        this.openLinksLock.waitLock(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new TransportException("Waited too long for the connection to onConnectionInit.");
                    }
                }
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    Boolean onConnectionInit(Connection connection) throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        Boolean ret = false;
        if (connection != null && this.session == null) {
            this.session = connection.session();
            this.session.open();
        }
        if (this.session != null) {
            if (this.isAuthenticationOpened().booleanValue()) {
                ret = true;
            } else {
                this.amqpsDeviceAuthentication.openLinks(this.session);
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
        return ret;
    }

    void onConnectionBound(Transport transport) throws TransportException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.session != null) {
            this.amqpsDeviceAuthentication.setSslDomain(transport);
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    void onLinkInit(Link link) throws TransportException, IllegalArgumentException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.session != null) {
            if (this.isAuthenticationOpened().booleanValue()) {
                for (int i = 0; i < this.amqpsDeviceSessionList.size(); ++i) {
                    this.amqpsDeviceSessionList.get(i).initLink(link);
                }
            } else {
                this.amqpsDeviceAuthentication.initLink(link);
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onLinkRemoteOpen(Event event) {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        Boolean isLinkFound = false;
        String linkName = event.getLink().getName();
        if (this.isAuthenticationOpened().booleanValue()) {
            for (int i = 0; i < this.amqpsDeviceSessionList.size(); ++i) {
                isLinkFound = this.amqpsDeviceSessionList.get(i).isLinkFound(linkName);
                if (!isLinkFound.booleanValue() || !this.amqpsDeviceSessionList.get(i).operationLinksOpened().booleanValue()) continue;
                this.logger.LogDebug("before notify openLinksLock.", new Object[0]);
                ObjectLock objectLock = this.openLinksLock;
                synchronized (objectLock) {
                    this.openLinksLock.notifyLock();
                }
                this.logger.LogDebug("after notify openLinksLock.", new Object[0]);
                break;
            }
        } else if (this.amqpsDeviceAuthentication.isLinkFound(linkName).booleanValue() && this.isAuthenticationOpened().booleanValue()) {
            isLinkFound = true;
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
        return isLinkFound;
    }

    Integer sendMessage(org.apache.qpid.proton.message.Message message, MessageType messageType, String deviceId) throws TransportException {
        Integer deliveryTag = -1;
        if (this.session != null) {
            for (int i = 0; i < this.amqpsDeviceSessionList.size() && (deliveryTag = this.amqpsDeviceSessionList.get(i).sendMessage(message, messageType, deviceId)) == -1; ++i) {
            }
        }
        return deliveryTag;
    }

    AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, TransportException {
        AmqpsMessage amqpsMessage = null;
        if (this.session != null) {
            if (this.isAuthenticationOpened().booleanValue()) {
                for (int i = 0; i < this.amqpsDeviceSessionList.size() && (amqpsMessage = this.amqpsDeviceSessionList.get(i).getMessageFromReceiverLink(linkName)) == null; ++i) {
                }
            } else {
                amqpsMessage = this.amqpsDeviceAuthentication.getMessageFromReceiverLink(linkName);
            }
        }
        return amqpsMessage;
    }

    boolean isLinkFound(String linkName) {
        Boolean isLinkFound = false;
        if (this.isAuthenticationOpened().booleanValue()) {
            for (int i = 0; i < this.amqpsDeviceSessionList.size() && !(isLinkFound = this.amqpsDeviceSessionList.get(i).isLinkFound(linkName)).booleanValue(); ++i) {
            }
        } else {
            isLinkFound = this.amqpsDeviceAuthentication.isLinkFound(linkName);
        }
        return isLinkFound;
    }

    boolean areAllLinksOpen() {
        boolean areAllLinksOpen = true;
        if (this.isAuthenticationOpened().booleanValue()) {
            for (int i = 0; i < this.amqpsDeviceSessionList.size(); ++i) {
                areAllLinksOpen &= this.amqpsDeviceSessionList.get(i).operationLinksOpened().booleanValue();
            }
        } else {
            return false;
        }
        return areAllLinksOpen;
    }

    Boolean isAuthenticationOpened() {
        return this.amqpsDeviceAuthentication.operationLinksOpened();
    }

    AmqpsConvertToProtonReturnValue convertToProton(Message message) throws TransportException {
        AmqpsConvertToProtonReturnValue amqpsConvertToProtonReturnValue = null;
        for (int i = 0; i < this.amqpsDeviceSessionList.size() && (amqpsConvertToProtonReturnValue = this.amqpsDeviceSessionList.get(i).convertToProton(message)) == null; ++i) {
        }
        return amqpsConvertToProtonReturnValue;
    }

    AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws TransportException {
        AmqpsConvertFromProtonReturnValue amqpsConvertFromProtonReturnValue = null;
        for (int i = 0; i < this.amqpsDeviceSessionList.size() && (amqpsConvertFromProtonReturnValue = this.amqpsDeviceSessionList.get(i).convertFromProton(amqpsMessage, deviceClientConfig)) == null; ++i) {
        }
        return amqpsConvertFromProtonReturnValue;
    }

    private void shutDownScheduler() {
        if (this.taskSchedulerCBSSend != null) {
            this.taskSchedulerCBSSend.shutdown();
            try {
                if (!this.taskSchedulerCBSSend.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.taskSchedulerCBSSend.shutdownNow();
                    if (!this.taskSchedulerCBSSend.awaitTermination(10L, TimeUnit.SECONDS)) {
                        System.err.println("taskSchedulerTokenRenewal did not terminate correctly");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.taskSchedulerCBSSend.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

