/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;

public class TopicParser {
    private String[] topicTokens = null;
    private final String QUESTION = "?";
    private final String REQ_ID = "$rid=";
    private final String VERSION = "$version=";

    public TopicParser(String topic) throws TransportException {
        if (topic == null || topic.length() == 0) {
            throw new TransportException(new IllegalArgumentException("topic cannot be null or empty"));
        }
        this.topicTokens = topic.split("/");
    }

    protected String getStatus(int tokenIndexStatus) throws TransportException {
        String status = null;
        if (tokenIndexStatus <= 0 || tokenIndexStatus >= this.topicTokens.length) {
            throw new TransportException(new IllegalArgumentException("Invalid token Index for status"));
        }
        if (this.topicTokens.length > tokenIndexStatus) {
            String token = this.topicTokens[tokenIndexStatus];
            if (token != null) {
                status = token;
            } else {
                throw new TransportException("Status could not be parsed");
            }
        }
        return status;
    }

    String getRequestId(int tokenIndexReqID) throws TransportException {
        String token;
        String reqId = null;
        if (tokenIndexReqID <= 0 || tokenIndexReqID >= this.topicTokens.length) {
            throw new TransportException(new IllegalArgumentException("Invalid token Index for request id"));
        }
        if (this.topicTokens.length > tokenIndexReqID && (token = this.topicTokens[tokenIndexReqID]).contains("$rid=") && token.contains("?")) {
            int startIndex = token.indexOf("$rid=") + "$rid=".length();
            int endIndex = token.length();
            if (token.contains("$version=") && !token.contains("?$version=")) {
                endIndex = token.indexOf("$version=") - 1;
            }
            reqId = token.substring(startIndex, endIndex);
        }
        return reqId;
    }

    protected String getVersion(int tokenIndexVersion) throws TransportException {
        String token;
        String version = null;
        if (tokenIndexVersion <= 0 || tokenIndexVersion >= this.topicTokens.length) {
            throw new TransportException(new IllegalArgumentException("Invalid token Index for Version"));
        }
        if (this.topicTokens.length > tokenIndexVersion && (token = this.topicTokens[tokenIndexVersion]).contains("$version=") && token.contains("?")) {
            int startIndex = token.indexOf("$version=") + "$version=".length();
            int endIndex = token.length();
            if (!token.contains("?$rid=") && token.contains("$rid=")) {
                endIndex = token.indexOf("$rid=") - 1;
            }
            version = token.substring(startIndex, endIndex);
        }
        return version;
    }

    String getMethodName(int tokenIndexMethod) throws TransportException {
        String methodName = null;
        if (tokenIndexMethod <= 0 || tokenIndexMethod >= this.topicTokens.length) {
            throw new TransportException(new IllegalArgumentException("Invalid token Index for Method Name"));
        }
        if (this.topicTokens.length > tokenIndexMethod) {
            String token = this.topicTokens[tokenIndexMethod];
            if (token != null) {
                methodName = token;
            } else {
                throw new TransportException(new IllegalArgumentException("method name could not be parsed"));
            }
        }
        return methodName;
    }
}

