/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions;

import com.microsoft.azure.sdk.iot.device.exceptions.ProtocolException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttBadUsernameOrPasswordException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttIdentifierRejectedException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttRejectedProtocolVersionException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttServerUnavailableException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttUnauthorizedException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttUnexpectedErrorException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.eclipse.paho.client.mqttv3.MqttException;

public class PahoExceptionTranslator {
    private static final int UNDEFINED_MQTT_CONNECT_CODE_LOWER_BOUND = 6;
    private static final int UNDEFINED_MQTT_CONNECT_CODE_UPPER_BOUND = 255;

    public static ProtocolException convertToMqttException(MqttException pahoException, String errorMessage) {
        switch (pahoException.getReasonCode()) {
            case 0: {
                if (pahoException.getCause() instanceof UnknownHostException || pahoException.getCause() instanceof NoRouteToHostException || pahoException.getCause() instanceof InterruptedException || pahoException.getCause() instanceof SocketTimeoutException || pahoException.getCause() instanceof SocketException) {
                    ProtocolException connectionException = new ProtocolException(errorMessage, (Throwable)pahoException);
                    connectionException.setRetryable(true);
                    return connectionException;
                }
                return new ProtocolException(errorMessage, (Throwable)pahoException);
            }
            case 1: {
                return new MqttRejectedProtocolVersionException(errorMessage, (Throwable)pahoException);
            }
            case 2: {
                return new MqttIdentifierRejectedException(errorMessage, (Throwable)pahoException);
            }
            case 3: {
                return new MqttServerUnavailableException(errorMessage, (Throwable)pahoException);
            }
            case 4: {
                return new MqttBadUsernameOrPasswordException(errorMessage, (Throwable)pahoException);
            }
            case 5: {
                return new MqttUnauthorizedException(errorMessage, (Throwable)pahoException);
            }
            case 128: 
            case 32000: 
            case 32002: 
            case 32103: 
            case 32104: 
            case 32109: 
            case 32110: 
            case 32201: 
            case 32202: {
                ProtocolException connectionException = new ProtocolException(errorMessage, (Throwable)pahoException);
                connectionException.setRetryable(true);
                return connectionException;
            }
        }
        if (pahoException.getReasonCode() >= 6 && pahoException.getReasonCode() <= 255) {
            return new MqttUnexpectedErrorException(errorMessage, (Throwable)pahoException);
        }
        return new ProtocolException(errorMessage, (Throwable)pahoException);
    }
}

