/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CustomLogger {
    private final Logger logger;
    private static final int CALLING_METHOD_NAME_DEPTH = 2;

    public CustomLogger(Class<?> clazz) {
        this.logger = Logger.getLogger(clazz);
    }

    public void LogInfo(String message, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.INFO)) {
            this.logger.info((Object)String.format(message, params));
        }
    }

    public void LogDebug(String message, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.DEBUG)) {
            this.logger.debug((Object)String.format(message, params));
        }
    }

    public void LogDebug(String message, Throwable t, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.DEBUG)) {
            this.logger.debug((Object)String.format(message, params), t);
        }
    }

    public void LogTrace(String message, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.TRACE)) {
            this.logger.trace((Object)String.format(message, params));
        }
    }

    public void LogWarn(String message, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)String.format(message, params));
        }
    }

    public void LogFatal(String message, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.FATAL)) {
            this.logger.fatal((Object)String.format(message, params));
        }
    }

    public void LogError(String message, Object ... params) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)String.format(message, params));
        }
    }

    public void LogError(Throwable exception) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)exception);
        }
    }

    public String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }
}

