/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.device.MessageCallback;

public final class DeviceClientConfig {
    private long tokenValidSecs = 3600L;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 240000;
    private static final int DEFAULT_MESSAGE_LOCK_TIMEOUT_SECS = 180;
    private final IotHubConnectionString iotHubConnectionString;
    private String userCertificateString;
    private String pathToCertificate;
    private IotHubSSLContext iotHubSSLContext;
    private MessageCallback deviceMethodCallback;
    private Object deviceMethodMessageContext;
    private MessageCallback deviceTwinMessageCallback;
    private Object deviceTwinMessageContext;
    private MessageCallback messageCallback;
    private Object messageContext;
    private CustomLogger logger;

    public DeviceClientConfig(IotHubConnectionString iotHubConnectionString) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("connection string is null");
        }
        this.iotHubConnectionString = iotHubConnectionString;
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", this.iotHubConnectionString.getHostName(), this.iotHubConnectionString.getDeviceId(), this.logger.getMethodName());
    }

    public void setIotHubSSLContext(IotHubSSLContext iotHubSSLContext) {
        this.iotHubSSLContext = iotHubSSLContext;
    }

    public IotHubSSLContext getIotHubSSLContext() {
        return this.iotHubSSLContext;
    }

    public void setPathToCert(String pathToCertificate) {
        this.pathToCertificate = pathToCertificate;
    }

    public String getPathToCertificate() {
        return this.pathToCertificate;
    }

    public void setUserCertificateString(String userCertificateString) {
        this.userCertificateString = userCertificateString;
    }

    public String getUserCertificateString() {
        return this.userCertificateString;
    }

    public void setMessageCallback(MessageCallback callback, Object context) {
        this.messageCallback = callback;
        this.messageContext = context;
    }

    public String getIotHubHostname() {
        return this.iotHubConnectionString.getHostName();
    }

    public String getIotHubName() {
        return this.iotHubConnectionString.getHubName();
    }

    public String getDeviceId() {
        return this.iotHubConnectionString.getDeviceId();
    }

    public String getDeviceKey() {
        return this.iotHubConnectionString.getSharedAccessKey();
    }

    public String getSharedAccessToken() {
        return this.iotHubConnectionString.getSharedAccessToken();
    }

    public long getTokenValidSecs() {
        return this.tokenValidSecs;
    }

    public void setTokenValidSecs(long expiryTime) {
        this.tokenValidSecs = expiryTime;
    }

    public int getReadTimeoutMillis() {
        return 240000;
    }

    public MessageCallback getMessageCallback() {
        return this.messageCallback;
    }

    public Object getMessageContext() {
        return this.messageContext;
    }

    public void setDeviceMethodMessageCallback(MessageCallback callback, Object context) {
        this.deviceMethodCallback = callback;
        this.deviceMethodMessageContext = context;
    }

    public MessageCallback getDeviceMethodMessageCallback() {
        return this.deviceMethodCallback;
    }

    public Object getDeviceMethodMessageContext() {
        return this.deviceMethodMessageContext;
    }

    public void setDeviceTwinMessageCallback(MessageCallback callback, Object context) {
        this.deviceTwinMessageCallback = callback;
        this.deviceTwinMessageContext = context;
    }

    public MessageCallback getDeviceTwinMessageCallback() {
        return this.deviceTwinMessageCallback;
    }

    public Object getDeviceTwinMessageContext() {
        return this.deviceTwinMessageContext;
    }

    public int getMessageLockTimeoutSecs() {
        return 180;
    }

    protected DeviceClientConfig() {
        this.iotHubConnectionString = null;
        this.pathToCertificate = null;
        this.iotHubSSLContext = null;
    }
}

