/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.DeviceTwin;

import com.microsoft.azure.sdk.iot.deps.serializer.TwinChangedCallback;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinParser;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceTwinMessage;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Property;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public class DeviceTwin {
    private int requestId;
    private TwinParser twinParser = null;
    private DeviceIO deviceIO = null;
    private DeviceClientConfig config = null;
    private boolean isSubscribed = false;
    private final Object DEVICE_TWIN_LOCK = new Object();
    private IotHubEventCallback deviceTwinStatusCallback;
    private Object deviceTwinStatusCallbackContext;
    private PropertyCallBack<String, Object> deviceTwinGenericPropertyChangeCallback;
    private Object deviceTwinGenericPropertyChangeCallbackContext;
    private ConcurrentSkipListMap<String, Pair<PropertyCallBack<String, Object>, Object>> onDesiredPropertyChangeMap;

    public DeviceTwin(DeviceIO client, DeviceClientConfig config, IotHubEventCallback deviceTwinCallback, Object deviceTwinCallbackContext, PropertyCallBack genericPropertyCallback, Object genericPropertyCallbackContext) {
        if (client == null || config == null) {
            throw new IllegalArgumentException("Client or config cannot be null");
        }
        if (deviceTwinCallback == null) {
            throw new IllegalArgumentException("Device twin Callback cannot be null");
        }
        if (genericPropertyCallback == null) {
            throw new IllegalArgumentException("Generic property Callback cannot be null");
        }
        this.deviceIO = client;
        this.config = config;
        this.config.setDeviceTwinMessageCallback(new deviceTwinResponseMessageCallback(), null);
        this.requestId = 0;
        this.deviceTwinStatusCallback = deviceTwinCallback;
        this.deviceTwinStatusCallbackContext = deviceTwinCallbackContext;
        this.deviceTwinGenericPropertyChangeCallback = genericPropertyCallback;
        this.deviceTwinGenericPropertyChangeCallbackContext = genericPropertyCallbackContext;
        this.twinParser = new TwinParser((TwinChangedCallback)new OnDesiredPropertyChanged(), (TwinChangedCallback)new OnReportedPropertyChanged());
    }

    public void getDeviceTwin() {
        DeviceTwinMessage getTwinRequestMessage = new DeviceTwinMessage(new byte[0]);
        getTwinRequestMessage.setRequestId(String.valueOf(this.requestId++));
        getTwinRequestMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_REQUEST);
        this.deviceIO.sendEventAsync((Message)getTwinRequestMessage, new deviceTwinRequestMessageCallback(), null);
    }

    public synchronized void updateReportedProperties(Set<Property> reportedProperties) throws IOException {
        if (reportedProperties == null) {
            throw new IllegalArgumentException("Reported properties cannot be null");
        }
        if (this.twinParser == null) {
            throw new IOException("Initilaize twin object before using it");
        }
        HashMap<String, Object> reportedPropertiesMap = new HashMap<String, Object>();
        for (Property p : reportedProperties) {
            reportedPropertiesMap.put(p.getKey(), p.getValue());
        }
        String serializedReportedProperties = this.twinParser.updateReportedProperty(reportedPropertiesMap);
        if (serializedReportedProperties == null) {
            return;
        }
        DeviceTwinMessage updateReportedPropertiesRequest = new DeviceTwinMessage(serializedReportedProperties.getBytes());
        updateReportedPropertiesRequest.setRequestId(String.valueOf(this.requestId++));
        updateReportedPropertiesRequest.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST);
        this.deviceIO.sendEventAsync((Message)updateReportedPropertiesRequest, new deviceTwinRequestMessageCallback(), null);
    }

    public void subscribeDesiredPropertiesNotification(Map<Property, Pair<PropertyCallBack<String, Object>, Object>> onDesiredPropertyChange) {
        if (this.onDesiredPropertyChangeMap == null) {
            this.onDesiredPropertyChangeMap = new ConcurrentSkipListMap();
        }
        if (onDesiredPropertyChange != null) {
            for (Map.Entry<Property, Pair<PropertyCallBack<String, Object>, Object>> desired : onDesiredPropertyChange.entrySet()) {
                this.onDesiredPropertyChangeMap.put(desired.getKey().getKey(), desired.getValue());
            }
        }
        if (!this.isSubscribed) {
            DeviceTwinMessage desiredPropertiesNotificationRequest = new DeviceTwinMessage(new byte[0]);
            desiredPropertiesNotificationRequest.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST);
            this.deviceIO.sendEventAsync((Message)desiredPropertiesNotificationRequest, new deviceTwinRequestMessageCallback(), null);
        }
    }

    private final class deviceTwinRequestMessageCallback
    implements IotHubEventCallback {
        private deviceTwinRequestMessageCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(IotHubStatusCode responseStatus, Object callbackContext) {
            Object object = DeviceTwin.this.DEVICE_TWIN_LOCK;
            synchronized (object) {
                DeviceTwin.this.deviceTwinStatusCallback.execute(responseStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
            }
        }
    }

    private final class deviceTwinResponseMessageCallback
    implements MessageCallback {
        private deviceTwinResponseMessageCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IotHubMessageResult execute(Message message, Object callbackContext) {
            Object object = DeviceTwin.this.DEVICE_TWIN_LOCK;
            synchronized (object) {
                IotHubStatusCode iotHubStatus = IotHubStatusCode.ERROR;
                if (message.getMessageType() != MessageType.DeviceTwin) {
                    System.out.print("Unexpected message type received");
                    DeviceTwin.this.deviceTwinStatusCallback.execute(iotHubStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                    return IotHubMessageResult.ABANDON;
                }
                DeviceTwinMessage dtMessage = (DeviceTwinMessage)message;
                String status = dtMessage.getStatus();
                switch (dtMessage.getDeviceOperationType()) {
                    case DEVICE_OPERATION_TWIN_GET_RESPONSE: {
                        if (status != null) {
                            iotHubStatus = IotHubStatusCode.getIotHubStatusCode(Integer.parseInt(status));
                        }
                        DeviceTwin.this.deviceTwinStatusCallback.execute(iotHubStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                        if (iotHubStatus != IotHubStatusCode.OK) break;
                        DeviceTwin.this.twinParser.updateTwin(new String(dtMessage.getBytes(), Message.DEFAULT_IOTHUB_MESSAGE_CHARSET));
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE: {
                        if (status != null) {
                            iotHubStatus = IotHubStatusCode.getIotHubStatusCode(Integer.parseInt(status));
                        }
                        DeviceTwin.this.deviceTwinStatusCallback.execute(iotHubStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE: {
                        DeviceTwin.this.isSubscribed = true;
                        DeviceTwin.this.twinParser.updateDesiredProperty(new String(dtMessage.getBytes(), Message.DEFAULT_IOTHUB_MESSAGE_CHARSET));
                        break;
                    }
                }
                return IotHubMessageResult.COMPLETE;
            }
        }
    }

    private final class OnReportedPropertyChanged
    implements TwinChangedCallback {
        private OnReportedPropertyChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Map<String, Object> hashMap) {
            Object object = DeviceTwin.this.DEVICE_TWIN_LOCK;
            synchronized (object) {
            }
        }
    }

    private final class OnDesiredPropertyChanged
    implements TwinChangedCallback {
        private OnDesiredPropertyChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Map<String, Object> desiredPropertyMap) {
            Object object = DeviceTwin.this.DEVICE_TWIN_LOCK;
            synchronized (object) {
                if (desiredPropertyMap != null) {
                    Iterator<Map.Entry<String, Object>> desiredPropertyIt = desiredPropertyMap.entrySet().iterator();
                    while (desiredPropertyIt.hasNext()) {
                        Map.Entry<String, Object> desiredProperty = desiredPropertyIt.next();
                        if (DeviceTwin.this.onDesiredPropertyChangeMap != null && DeviceTwin.this.onDesiredPropertyChangeMap.containsKey(desiredProperty.getKey())) {
                            Pair callBackObjectPair = (Pair)DeviceTwin.this.onDesiredPropertyChangeMap.get(desiredProperty.getKey());
                            if (callBackObjectPair != null && callBackObjectPair.getKey() != null) {
                                ((PropertyCallBack)callBackObjectPair.getKey()).PropertyCall(desiredProperty.getKey(), desiredProperty.getValue(), callBackObjectPair.getValue());
                            } else {
                                DeviceTwin.this.deviceTwinGenericPropertyChangeCallback.PropertyCall(desiredProperty.getKey(), desiredProperty.getValue(), DeviceTwin.this.deviceTwinGenericPropertyChangeCallbackContext);
                            }
                        } else {
                            DeviceTwin.this.deviceTwinGenericPropertyChangeCallback.PropertyCall(desiredProperty.getKey(), desiredProperty.getValue(), DeviceTwin.this.deviceTwinGenericPropertyChangeCallbackContext);
                        }
                        desiredPropertyIt.remove();
                    }
                }
            }
        }
    }
}

