/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.DeviceTwin;

import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;

public class Property {
    private Pair<String, Object> property = null;

    public Property(String key, Object value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (key.contains(" ") || key.contains("$") || key.contains(".")) {
            throw new IllegalArgumentException("Key cannot contain illegal unicode control characters '.', '$', ' '");
        }
        this.property = new Pair<String, Object>(key, value);
    }

    public String getKey() {
        return this.property.getKey();
    }

    public Object getValue() {
        return this.property.getValue();
    }

    public void setValue(Object newValue) {
        this.property.setValue(newValue);
    }

    public String toString() {
        return this.getKey() + " - " + this.getValue();
    }
}

