/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class IotHubConnectionString {
    private static final String HOSTNAME_ATTRIBUTE = "HostName=";
    private static final String DEVICE_ID_ATTRIBUTE = "DeviceId=";
    private static final String SHARED_ACCESS_KEY_ATTRIBUTE = "SharedAccessKey=";
    private static final String SHARED_ACCESS_TOKEN_ATTRIBUTE = "SharedAccessSignature=";
    private static final Charset CONNECTION_STRING_CHARSET = StandardCharsets.UTF_8;
    private String hostName = null;
    private String hubName = null;
    private String deviceId = null;
    private String sharedAccessKey = null;
    private String sharedAccessToken = null;
    private CustomLogger logger = null;

    public IotHubConnectionString(String connectionString) throws URISyntaxException, IllegalArgumentException {
        String[] connStringAttrs;
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("The connection string cannot be null or empty.");
        }
        for (String attr : connStringAttrs = connectionString.split(";")) {
            if (attr.startsWith(HOSTNAME_ATTRIBUTE)) {
                this.hostName = attr.substring(HOSTNAME_ATTRIBUTE.length());
                continue;
            }
            if (attr.startsWith(DEVICE_ID_ATTRIBUTE)) {
                String urlEncodedDeviceId = attr.substring(DEVICE_ID_ATTRIBUTE.length());
                try {
                    this.deviceId = URLDecoder.decode(urlEncodedDeviceId, CONNECTION_STRING_CHARSET.name());
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (attr.startsWith(SHARED_ACCESS_KEY_ATTRIBUTE)) {
                this.sharedAccessKey = attr.substring(SHARED_ACCESS_KEY_ATTRIBUTE.length());
                continue;
            }
            if (!attr.startsWith(SHARED_ACCESS_TOKEN_ATTRIBUTE)) continue;
            this.sharedAccessToken = attr.substring(SHARED_ACCESS_TOKEN_ATTRIBUTE.length());
            if (!IotHubSasToken.isSasTokenExpired(this.sharedAccessToken)) continue;
            throw new SecurityException("Your SAS Token has expired");
        }
        IotHubConnectionString.validateTerms(this.hostName, this.deviceId, this.sharedAccessKey, this.sharedAccessToken);
        this.hubName = IotHubConnectionString.parseHubName(this.hostName);
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("IotHubConnectionString object is created successfully for %s, method name is %s ", this.hostName, this.logger.getMethodName());
    }

    public IotHubConnectionString(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken) throws URISyntaxException, IllegalArgumentException {
        IotHubConnectionString.validateTerms(hostName, deviceId, sharedAccessKey, sharedAccessToken);
        this.hostName = hostName;
        this.hubName = IotHubConnectionString.parseHubName(this.hostName);
        this.deviceId = deviceId;
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessToken = sharedAccessToken;
        if (this.sharedAccessToken != null && IotHubSasToken.isSasTokenExpired(this.sharedAccessToken)) {
            throw new SecurityException("Your SAS Token has expired");
        }
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("IotHubConnectionString object is created successfully for %s, method name is %s ", this.hostName, this.logger.getMethodName());
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHubName() {
        return this.hubName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessToken() {
        return this.sharedAccessToken;
    }

    private static void validateTerms(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken) throws URISyntaxException, IllegalArgumentException {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("IoT Hub hostName cannot be null.");
        }
        new URI(hostName);
        IotHubConnectionString.parseHubName(hostName);
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("Device ID cannot be null.");
        }
        if (sharedAccessKey != null && sharedAccessToken != null) {
            throw new IllegalArgumentException("Either of device key or Shared Access Signature should be provided.");
        }
        if ((sharedAccessKey == null || sharedAccessKey.isEmpty()) && (sharedAccessToken == null || sharedAccessToken.isEmpty())) {
            throw new IllegalArgumentException("Device key and Shared Access Signature both cannot be null.");
        }
    }

    private static String parseHubName(String hostName) throws IllegalArgumentException {
        int iotHubNameEndIdx = hostName.indexOf(".");
        if (iotHubNameEndIdx == -1) {
            String errStr = String.format("%s did not include a valid IoT Hub name as its prefix. An IoT Hub hostname has the following format: [iotHubName].[valid URI chars]", hostName);
            throw new IllegalArgumentException(errStr);
        }
        return hostName.substring(0, iotHubNameEndIdx);
    }
}

