/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.IotHubCertificateManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IotHubSSLContext {
    private SSLContext iotHubSslContext = null;

    IotHubSSLContext() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        this.generateSSLContext(defaultCert);
    }

    IotHubSSLContext(String cert, boolean isPath) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        if (cert == null) {
            throw new IllegalArgumentException("Cert cannot be null");
        }
        IotHubCertificateManager certManager = new IotHubCertificateManager();
        if (isPath) {
            certManager.setValidCertPath(cert);
        } else {
            certManager.setValidCert(cert);
        }
        this.generateSSLContext(certManager);
    }

    IotHubSSLContext(String pathToCertificate, String userCertificateString) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        IotHubCertificateManager certManager = new IotHubCertificateManager();
        if (pathToCertificate != null) {
            certManager.setValidCertPath(pathToCertificate);
        } else if (userCertificateString != null) {
            certManager.setValidCert(userCertificateString);
        }
        this.generateSSLContext(certManager);
    }

    private void generateSSLContext(IotHubCertificateManager certificate) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        for (Certificate certificate2 : certificate.getCertificateCollection()) {
            keyStore.setCertificateEntry("trustedIotHubCert-" + UUID.randomUUID(), certificate2);
        }
        trustManagerFactory.init(keyStore);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
        this.iotHubSslContext = sslContext;
    }

    public SSLContext getIotHubSSlContext() {
        return this.iotHubSslContext;
    }
}

