/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.auth.Signature;
import com.microsoft.azure.sdk.iot.device.net.IotHubUri;
import java.util.HashMap;
import java.util.Map;

public final class IotHubSasToken {
    private static final String TOKEN_FORMAT = "SharedAccessSignature sig=%s&se=%s&sr=%s";
    private String sasToken = null;
    private String signature = null;
    private long expiryTime = 0L;
    private String scope = null;
    private static final String SharedAccessSignature = "SharedAccessSignature";
    private static final String FieldPairSeparator = "&";
    private static final String FieldKeyValueSeparator = "=";
    private static final String ExpiryTimeFieldKey = "se";
    private static final String SignatureFieldKey = "sig";
    private static final String ResourceURIFieldKey = "sr";
    private static final int ExpectedNumberOfFieldParts = 2;
    private static final int KeyValuePairKeyIndex = 0;
    private static final int KeyValuePairValueIndex = 1;
    private static final int SASTokenConstantSegmentIndex = 0;
    private static final int SASTokenFieldSegmentIndex = 1;
    private static final int ExpectedSASTokenSegments = 2;
    private static final String SASTokenSegmentSeparator = " ";

    public IotHubSasToken(DeviceClientConfig config, long expiryTime) {
        if (config.getDeviceKey() != null) {
            this.scope = IotHubUri.getResourceUri(config.getIotHubHostname(), config.getDeviceId());
            this.expiryTime = expiryTime;
            Signature sig = new Signature(this.scope, this.expiryTime, config.getDeviceKey());
            this.signature = sig.toString();
        } else if (config.getSharedAccessToken() != null) {
            this.sasToken = config.getSharedAccessToken();
            this.expiryTime = IotHubSasToken.getExpiryTimeFromToken(this.sasToken);
            if (!this.isSasFormat()) {
                throw new IllegalArgumentException("SasToken format is invalid");
            }
            if (IotHubSasToken.isSasTokenExpired(this.sasToken)) {
                throw new SecurityException("Your SasToken has expired");
            }
        } else {
            this.signature = null;
            this.sasToken = null;
        }
    }

    public String toString() {
        if (this.sasToken != null) {
            if (this.isSasFormat()) {
                return this.sasToken;
            }
            throw new IllegalArgumentException("SasToken format is invalid");
        }
        if (this.signature != null && this.expiryTime != 0L && this.scope != null) {
            return this.buildSasToken();
        }
        return null;
    }

    private boolean isSasFormat() {
        Map<String, String> fieldValues;
        return this.sasToken != null && this.sasToken.startsWith(SharedAccessSignature) && (fieldValues = IotHubSasToken.extractFieldValues(this.sasToken)).containsKey(ExpiryTimeFieldKey) && fieldValues.containsKey(SignatureFieldKey) && fieldValues.containsKey(ResourceURIFieldKey);
    }

    public static boolean isSasTokenExpired(String sasToken) {
        Long currentTime = System.currentTimeMillis() / 1000L;
        Long expiryTime = IotHubSasToken.getExpiryTimeFromToken(sasToken);
        return currentTime >= expiryTime;
    }

    public boolean isSasTokenExpired() {
        return System.currentTimeMillis() / 1000L >= this.expiryTime;
    }

    public static Long getExpiryTimeFromToken(String sasToken) {
        Map<String, String> fieldValues = IotHubSasToken.extractFieldValues(sasToken);
        return Long.parseLong(fieldValues.get(ExpiryTimeFieldKey));
    }

    private static Map<String, String> extractFieldValues(String sharedAccessSignature) {
        String[] fields;
        String[] lines = sharedAccessSignature.split(SASTokenSegmentSeparator);
        String sasTokenFirstSegment = lines[0].trim().toUpperCase();
        boolean sasTokenFirstSegmentMatchesExpected = sasTokenFirstSegment.equals(SharedAccessSignature.toUpperCase());
        if (lines.length != 2 || !sasTokenFirstSegmentMatchesExpected) {
            throw new IllegalArgumentException("Malformed signature");
        }
        HashMap<String, String> parsedFields = new HashMap<String, String>();
        for (String field : fields = lines[1].trim().split(FieldPairSeparator)) {
            if (field.equals("")) continue;
            String[] fieldParts = field.split(FieldKeyValueSeparator);
            if (fieldParts.length != 2) {
                throw new IllegalArgumentException("SasToken format is invalid: missing a key or value tied to your field: " + field);
            }
            parsedFields.put(fieldParts[0], fieldParts[1]);
        }
        return parsedFields;
    }

    private String buildSasToken() {
        return String.format(TOKEN_FORMAT, this.signature, this.expiryTime, this.scope);
    }

    protected IotHubSasToken() {
        this.signature = null;
        this.expiryTime = 0L;
        this.scope = null;
        this.sasToken = null;
    }
}

