/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;

public final class IotHubReceiveTask
implements Runnable {
    private final IotHubTransport transport;
    private final CustomLogger logger = new CustomLogger(this.getClass());

    public IotHubReceiveTask(IotHubTransport transport) {
        if (transport == null) {
            this.logger.LogError("IotHubReceiveTask constructor called with null value for parameter transport", new Object[0]);
            throw new IllegalArgumentException("Parameter 'transport' must not be null");
        }
        this.transport = transport;
    }

    @Override
    public void run() {
        this.logger.LogTrace("Now trying to receive messages from IoT Hub", new Object[0]);
        try {
            this.transport.handleMessage();
            this.logger.LogTrace("Successfully received messages from IoT Hub", new Object[0]);
        }
        catch (Throwable e) {
            this.logger.LogError(e.toString() + ": " + e.getMessage(), new Object[0]);
            this.logger.LogDebug("Exception on sending queued messages to IoT Hub", e, new Object[0]);
        }
    }
}

