/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HttpsRequest {
    private final HttpsConnection connection;

    public HttpsRequest(URL url, HttpsMethod method, byte[] body) throws IOException {
        this.connection = new HttpsConnection(url, method);
        this.connection.setRequestHeader("User-Agent", "com.microsoft.azure.sdk.iot.iot-device-client/1.3.30");
        this.connection.writeOutput(body);
    }

    public HttpsResponse send() throws IOException {
        Map<String, List<String>> headerFields;
        int responseStatus = -1;
        byte[] responseBody = new byte[]{};
        byte[] errorReason = new byte[]{};
        try {
            this.connection.connect();
            responseStatus = this.connection.getResponseStatus();
            headerFields = this.connection.getResponseHeaders();
            responseBody = this.connection.readInput();
        }
        catch (IOException e) {
            responseStatus = this.connection.getResponseStatus();
            headerFields = this.connection.getResponseHeaders();
            errorReason = this.connection.readError();
        }
        return new HttpsResponse(responseStatus, responseBody, headerFields, errorReason);
    }

    public HttpsRequest setHeaderField(String field, String value) {
        this.connection.setRequestHeader(field, value);
        return this;
    }

    public HttpsRequest setReadTimeoutMillis(int timeout) {
        this.connection.setReadTimeoutMillis(timeout);
        return this;
    }

    public HttpsRequest setSSLContext(IotHubSSLContext iotHubSSLContext) {
        if (iotHubSSLContext == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.connection.setSSLContext(iotHubSSLContext.getIotHubSSlContext());
        return this;
    }

    protected HttpsRequest() {
        this.connection = null;
    }
}

