/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportManager;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.io.IOException;

public class HttpsTransportManager
implements IotHubTransportManager {
    DeviceClientConfig config;
    HttpsIotHubConnection httpsIotHubConnection;

    public HttpsTransportManager(DeviceClientConfig config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
    }

    @Override
    public void open() {
        this.httpsIotHubConnection = new HttpsIotHubConnection(this.config);
    }

    @Override
    public void open(String[] topics) {
        this.httpsIotHubConnection = new HttpsIotHubConnection(this.config);
    }

    @Override
    public void close() {
        this.httpsIotHubConnection = null;
    }

    @Override
    public ResponseMessage send(IotHubTransportMessage message) throws IOException, IllegalArgumentException {
        HttpsMethod httpsMethod;
        HttpsSingleMessage httpsMessage = HttpsSingleMessage.parseHttpsJsonMessage(message);
        if (message.getIotHubMethod() == null || message.getUriPath() == null) {
            throw new IllegalArgumentException("method or path is null");
        }
        switch (message.getIotHubMethod()) {
            case GET: {
                httpsMethod = HttpsMethod.GET;
                break;
            }
            case POST: {
                httpsMethod = HttpsMethod.POST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IoT Hub type " + message.getIotHubMethod().toString());
            }
        }
        String httpsPath = message.getUriPath();
        return this.httpsIotHubConnection.sendHttpsMessage(httpsMessage, httpsMethod, httpsPath);
    }

    @Override
    public Message receive() throws IOException {
        return this.httpsIotHubConnection.receiveMessage();
    }
}

