/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodMessage;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.TopicParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MqttDeviceMethod
extends Mqtt {
    private String subscribeTopic = "$iothub/methods/POST/#";
    private String responseTopic = "$iothub/methods/res";
    private final Map<String, DeviceOperations> requestMap = new HashMap<String, DeviceOperations>();
    private boolean isStarted = false;
    private final CustomLogger logger = new CustomLogger(this.getClass());
    private final String POUND = "#";
    private final String BACKSLASH = "/";
    private final String QUESTION = "?";
    private final String METHOD = "$iothub/methods/";
    private final String POST = "$iothub/methods/POST";
    private final String RES = "$iothub/methods/res";
    private final String REQ_ID = "?$rid=";
    private final int POST_TOKEN = 2;
    private final int METHOD_TOKEN = 3;
    private final int REQID_TOKEN = 4;

    public void start() {
        if (!this.isStarted) {
            this.isStarted = true;
        }
    }

    public void stop() throws IOException {
        if (this.isStarted) {
            this.unsubscribe(this.subscribeTopic);
            this.isStarted = false;
        }
        if (!this.requestMap.isEmpty()) {
            this.logger.LogInfo("Pending %d responses to be sent to IotHub yet unsubscribed %s", this.requestMap.size(), this.logger.getMethodName());
        }
    }

    @Override
    String parseTopic() throws IOException {
        String topic = null;
        if (allReceivedMessages == null) {
            throw new IOException("Queue cannot be null");
        }
        if (!allReceivedMessages.isEmpty()) {
            for (Map.Entry data : allReceivedMessages.entrySet()) {
                String topicFound = (String)data.getKey();
                if (topicFound == null || topicFound.length() <= "$iothub/methods/".length() || !topicFound.startsWith("$iothub/methods/")) continue;
                topic = topicFound;
                break;
            }
        }
        return topic;
    }

    @Override
    byte[] parsePayload(String topic) throws IOException {
        if (topic == null) {
            return null;
        }
        if (allReceivedMessages == null) {
            throw new IOException("Invalid State - topic is not null and could not be found in queue");
        }
        if (!allReceivedMessages.containsKey(topic)) {
            throw new IOException("Topic should be present in received queue at this point");
        }
        if (!allReceivedMessages.isEmpty()) {
            return (byte[])allReceivedMessages.remove(topic);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(DeviceMethodMessage message) throws IOException {
        if (message == null || message.getBytes() == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        if (!this.isStarted) {
            throw new IOException("Start device method before using send");
        }
        if (message.getMessageType() != MessageType.DeviceMethods) {
            return;
        }
        switch (message.getDeviceOperationType()) {
            case DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST: {
                this.subscribe(this.subscribeTopic);
                return;
            }
            case DEVICE_OPERATION_METHOD_SEND_RESPONSE: {
                if (message.getRequestId() == null || message.getRequestId().isEmpty()) {
                    throw new IOException("Request id cannot be null or empty");
                }
                if (!this.requestMap.containsKey(message.getRequestId())) throw new IOException("Sending a response for the method that was never invoked");
                switch (this.requestMap.remove(message.getRequestId())) {
                    case DEVICE_OPERATION_METHOD_RECEIVE_REQUEST: {
                        break;
                    }
                    default: {
                        throw new IOException("Mismatched request and response operation");
                    }
                }
                String topic = this.responseTopic + "/" + message.getStatus() + "/" + "?$rid=" + message.getRequestId();
                this.publish(topic, message.getBytes());
                return;
            }
            default: {
                throw new IOException("Mismatched device method operation");
            }
        }
    }

    @Override
    public Message receive() throws IOException {
        DeviceMethodMessage message = null;
        String topic = this.parseTopic();
        if (topic != null && topic.length() > 0) {
            byte[] data = this.parsePayload(topic);
            if (topic.length() > "$iothub/methods/POST".length() && topic.startsWith("$iothub/methods/POST")) {
                TopicParser topicParser = new TopicParser(topic);
                if (data != null && data.length > 0) {
                    message = new DeviceMethodMessage(data);
                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                } else {
                    message = new DeviceMethodMessage(new byte[0]);
                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                }
                try {
                    String methodName = topicParser.getMethodName(3);
                    message.setMethodName(methodName);
                }
                catch (Exception e) {
                    throw new IOException("Method name could not be parsed");
                }
                try {
                    String reqId = topicParser.getRequestId(4);
                    if (reqId == null) {
                        throw new IOException("Request ID cannot be null");
                    }
                    message.setRequestId(reqId);
                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
                    this.requestMap.put(reqId, DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
                }
                catch (Exception e) {
                    throw new IOException("Method Invoke received without request ID");
                }
            }
            throw new UnsupportedOperationException();
        }
        return message;
    }
}

