/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodMessage;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceTwinMessage;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.transport.State;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceMethod;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceTwin;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessaging;
import java.io.IOException;
import java.net.URLEncoder;

public class MqttIotHubConnection {
    private final Object MQTT_CONNECTION_LOCK = new Object();
    private final DeviceClientConfig config;
    private State state = State.CLOSED;
    private String iotHubUserName;
    private String iotHubUserPassword;
    private static final String SSL_PREFIX = "ssl://";
    private static final String SSL_PORT_SUFFIX = ":8883";
    private static final String TWIN_API_VERSION = "api-version=2016-11-14";
    private MqttMessaging deviceMessaging;
    private MqttDeviceTwin deviceTwin;
    private MqttDeviceMethod deviceMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttIotHubConnection(DeviceClientConfig config) throws IllegalArgumentException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (config == null) {
                throw new IllegalArgumentException("The DeviceClientConfig cannot be null.");
            }
            if (config.getIotHubHostname() == null || config.getIotHubHostname().length() == 0) {
                throw new IllegalArgumentException("hostName cannot be null or empty.");
            }
            if (config.getDeviceId() == null || config.getDeviceId().length() == 0) {
                throw new IllegalArgumentException("deviceID cannot be null or empty.");
            }
            if (config.getIotHubName() == null || config.getIotHubName().length() == 0) {
                throw new IllegalArgumentException("hubName cannot be null or empty.");
            }
            if (!(config.getDeviceKey() != null && config.getDeviceKey().length() != 0 || config.getSharedAccessToken() != null && config.getSharedAccessToken().length() != 0)) {
                throw new IllegalArgumentException("Both deviceKey and shared access signature cannot be null or empty.");
            }
            this.config = config;
            this.deviceMessaging = null;
            this.deviceMethod = null;
            this.deviceTwin = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (this.state == State.OPEN) {
                return;
            }
            try {
                IotHubSasToken sasToken = new IotHubSasToken(this.config, System.currentTimeMillis() / 1000L + this.config.getTokenValidSecs() + 1L);
                this.iotHubUserPassword = sasToken.toString();
                String clientIdentifier = "DeviceClientType=" + URLEncoder.encode("com.microsoft.azure.sdk.iot.iot-device-client/1.3.30", "UTF-8");
                this.iotHubUserName = this.config.getIotHubHostname() + "/" + this.config.getDeviceId() + "/" + TWIN_API_VERSION + "/" + clientIdentifier;
                this.deviceMessaging = new MqttMessaging(SSL_PREFIX + this.config.getIotHubHostname() + SSL_PORT_SUFFIX, this.config.getDeviceId(), this.iotHubUserName, this.iotHubUserPassword, this.config.getIotHubSSLContext());
                this.deviceMethod = new MqttDeviceMethod();
                this.deviceTwin = new MqttDeviceTwin();
                this.deviceMessaging.start();
                this.state = State.OPEN;
            }
            catch (Exception e) {
                this.state = State.CLOSED;
                if (this.deviceMethod != null) {
                    this.deviceMethod.stop();
                }
                if (this.deviceTwin != null) {
                    this.deviceTwin.stop();
                }
                if (this.deviceMessaging != null) {
                    this.deviceMessaging.stop();
                }
                throw new IOException(e.getMessage(), e.getCause());
            }
        }
    }

    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        try {
            this.deviceMethod.stop();
            this.deviceMethod = null;
            this.deviceTwin.stop();
            this.deviceTwin = null;
            this.deviceMessaging.stop();
            this.deviceMessaging = null;
            this.state = State.CLOSED;
        }
        catch (Exception e) {
            this.state = State.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IotHubStatusCode sendEvent(Message message) throws IllegalStateException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (message == null || message.getBytes() == null || message.getMessageType() != MessageType.DeviceTwin && message.getMessageType() != MessageType.DeviceMethods && message.getBytes().length == 0) {
                return IotHubStatusCode.BAD_FORMAT;
            }
            if (this.state == State.CLOSED) {
                throw new IllegalStateException("Cannot send event using a closed MQTT connection");
            }
            IotHubStatusCode result = IotHubStatusCode.OK_EMPTY;
            try {
                if (message.getMessageType() == MessageType.DeviceMethods) {
                    this.deviceMethod.start();
                    this.deviceMethod.send((DeviceMethodMessage)message);
                } else if (message.getMessageType() == MessageType.DeviceTwin) {
                    this.deviceTwin.start();
                    this.deviceTwin.send((DeviceTwinMessage)message);
                } else {
                    this.deviceMessaging.send(message);
                }
            }
            catch (Exception e) {
                result = IotHubStatusCode.ERROR;
            }
            return result;
        }
    }

    public Message receiveMessage() throws IllegalStateException, IOException {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("The MQTT connection is currently closed. Call open() before attempting to receive a message.");
        }
        Message message = null;
        message = this.deviceMethod.receive();
        if (message == null) {
            message = this.deviceTwin.receive();
        }
        if (message == null) {
            message = this.deviceMessaging.receive();
        }
        return message;
    }
}

