/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import java.io.IOException;
import java.util.Map;

public class MqttMessaging
extends Mqtt {
    private String subscribeTopic;
    private String publishTopic;
    private String parseTopic;

    @Override
    String parseTopic() throws IOException {
        String topic = null;
        if (allReceivedMessages == null) {
            throw new IOException("Queue cannot be null");
        }
        if (!allReceivedMessages.isEmpty()) {
            for (Map.Entry data : allReceivedMessages.entrySet()) {
                String topicFound = (String)data.getKey();
                if (topicFound == null || topicFound.length() <= this.parseTopic.length() || !topicFound.startsWith(this.parseTopic)) continue;
                topic = topicFound;
                break;
            }
        }
        return topic;
    }

    @Override
    byte[] parsePayload(String topic) throws IOException {
        if (topic == null) {
            return null;
        }
        if (allReceivedMessages == null) {
            throw new IOException("Invalid State - topic is not null and could not be found in queue");
        }
        if (!allReceivedMessages.containsKey(topic)) {
            throw new IOException("Topic is should be present in received queue at this point");
        }
        if (!allReceivedMessages.isEmpty()) {
            return (byte[])allReceivedMessages.remove(topic);
        }
        return null;
    }

    public MqttMessaging(String serverURI, String deviceId, String userName, String password, IotHubSSLContext context) throws IOException {
        super(serverURI, deviceId, userName, password, context);
        this.publishTopic = "devices/" + deviceId + "/messages/events/";
        this.subscribeTopic = "devices/" + deviceId + "/messages/devicebound/#";
        this.parseTopic = "devices/" + deviceId + "/messages/devicebound/";
    }

    public void start() throws IOException {
        this.connect();
        this.subscribe(this.subscribeTopic);
    }

    public void stop() throws IOException {
        try {
            this.disconnect();
        }
        finally {
            this.restartBaseMqtt();
        }
    }

    public void send(Message message) throws IOException {
        String messagePublishTopic;
        if (message == null || message.getBytes() == null) {
            throw new IOException("Message cannot be null");
        }
        MessageProperty[] messageProperties = message.getProperties();
        if (messageProperties.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.publishTopic);
            boolean separatorNeeded = false;
            if (message.getMessageId() != null) {
                stringBuilder.append("$.mid");
                stringBuilder.append('=');
                stringBuilder.append(message.getMessageId());
                separatorNeeded = true;
            }
            if (message.getCorrelationId() != null) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("$.cid");
                stringBuilder.append('=');
                stringBuilder.append(message.getCorrelationId());
                separatorNeeded = true;
            }
            if (message.getUserId() != null) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("$.uid");
                stringBuilder.append('=');
                stringBuilder.append(message.getUserId());
                separatorNeeded = true;
            }
            if (message.getTo() != null) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("$.to");
                stringBuilder.append('=');
                stringBuilder.append(message.getTo());
                separatorNeeded = true;
            }
            for (MessageProperty property : message.getProperties()) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(property.getName());
                stringBuilder.append('=');
                stringBuilder.append(property.getValue());
                separatorNeeded = true;
            }
            messagePublishTopic = stringBuilder.toString();
        } else {
            messagePublishTopic = this.publishTopic;
        }
        this.publish(messagePublishTopic, message.getBytes());
    }
}

