/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubResponseCallback;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubCallbackPacket;
import com.microsoft.azure.sdk.iot.device.transport.IotHubOutboundPacket;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import com.microsoft.azure.sdk.iot.device.transport.State;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttIotHubConnection;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public final class MqttTransport
implements IotHubTransport {
    protected final Object sendMessagesLock = new Object();
    protected final Object handleMessageLock = new Object();
    private State state;
    private MqttIotHubConnection mqttIotHubConnection;
    private final Queue<IotHubOutboundPacket> waitingList = new LinkedBlockingDeque<IotHubOutboundPacket>();
    private final Queue<IotHubCallbackPacket> callbackList = new LinkedBlockingDeque<IotHubCallbackPacket>();
    private final DeviceClientConfig config;

    public MqttTransport(DeviceClientConfig config) {
        this.config = config;
        this.state = State.CLOSED;
    }

    @Override
    public void open() throws IOException {
        if (this.state == State.OPEN) {
            return;
        }
        this.mqttIotHubConnection = new MqttIotHubConnection(this.config);
        this.mqttIotHubConnection.open();
        this.state = State.OPEN;
    }

    @Override
    public void close() throws IOException {
        if (this.state == State.CLOSED) {
            return;
        }
        while (!this.waitingList.isEmpty()) {
            IotHubOutboundPacket packet = this.waitingList.remove();
            IotHubCallbackPacket callbackPacket = new IotHubCallbackPacket(IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE, packet.getCallback(), packet.getContext());
            this.callbackList.add(callbackPacket);
        }
        this.invokeCallbacks();
        this.mqttIotHubConnection.close();
        this.state = State.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(Message message, IotHubEventCallback callback, Object callbackContext) throws IllegalStateException {
        Object object = this.sendMessagesLock;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                throw new IllegalStateException("Cannot add a message to an MQTT transport that is closed.");
            }
            IotHubOutboundPacket packet = new IotHubOutboundPacket(message, callback, callbackContext);
            this.waitingList.add(packet);
        }
    }

    @Override
    public void addMessage(Message message, IotHubResponseCallback callback, Object callbackContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("MQTT do not support callback with message response");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessages() throws IllegalStateException {
        Object object = this.sendMessagesLock;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                throw new IllegalStateException("MQTT transport is closed.");
            }
            if (this.waitingList.size() <= 0) {
                return;
            }
            while (!this.waitingList.isEmpty()) {
                IotHubOutboundPacket packet = this.waitingList.remove();
                try {
                    IotHubStatusCode status = this.mqttIotHubConnection.sendEvent(packet.getMessage());
                    IotHubCallbackPacket callbackPacket = new IotHubCallbackPacket(status, packet.getCallback(), packet.getContext());
                    this.callbackList.add(callbackPacket);
                }
                catch (IllegalStateException e) {
                    this.waitingList.add(packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeCallbacks() throws IllegalStateException {
        Object object = this.sendMessagesLock;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                throw new IllegalStateException("MQTT transport is closed.");
            }
            while (!this.callbackList.isEmpty()) {
                IotHubCallbackPacket packet = this.callbackList.remove();
                IotHubStatusCode status = packet.getStatus();
                IotHubEventCallback callback = packet.getCallback();
                Object context = packet.getContext();
                callback.execute(status, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage() throws IllegalStateException, IOException {
        Object object = this.handleMessageLock;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                throw new IllegalStateException("MQTT transport is closed.");
            }
            MessageCallback callback = this.config.getMessageCallback();
            Object context = this.config.getMessageContext();
            MessageCallback deviceTwinMessageCallback = this.config.getDeviceTwinMessageCallback();
            Object deviceTwinContext = this.config.getDeviceTwinMessageContext();
            MessageCallback deviceMethodMessageCallback = this.config.getDeviceMethodMessageCallback();
            Object deviceMethodContext = this.config.getDeviceMethodMessageContext();
            if (callback == null && deviceTwinMessageCallback == null && deviceMethodMessageCallback == null) {
                return;
            }
            Message message = this.mqttIotHubConnection.receiveMessage();
            if (message != null) {
                if (message.getMessageType() == MessageType.DeviceMethods) {
                    if (deviceMethodMessageCallback != null) {
                        deviceMethodMessageCallback.execute(message, deviceMethodContext);
                    }
                } else if (message.getMessageType() == MessageType.DeviceTwin) {
                    if (deviceTwinMessageCallback != null) {
                        deviceTwinMessageCallback.execute(message, deviceTwinContext);
                    }
                } else if (callback != null) {
                    callback.execute(message, context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.sendMessagesLock;
        synchronized (object) {
            if (this.waitingList.isEmpty() && this.callbackList.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) {
        throw new UnsupportedOperationException();
    }
}

