/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethod;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodCallback;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceTwin;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Property;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.fileupload.FileUpload;
import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;

public final class DeviceClient
implements Closeable {
    @Deprecated
    public static long SEND_PERIOD_MILLIS = 10L;
    @Deprecated
    public static long RECEIVE_PERIOD_MILLIS_AMQPS = 10L;
    @Deprecated
    public static long RECEIVE_PERIOD_MILLIS_MQTT = 10L;
    @Deprecated
    public static long RECEIVE_PERIOD_MILLIS_HTTPS = 1500000L;
    @Deprecated
    public static final String HOSTNAME_ATTRIBUTE = "HostName=";
    @Deprecated
    public static final String DEVICE_ID_ATTRIBUTE = "DeviceId=";
    @Deprecated
    public static final String SHARED_ACCESS_KEY_ATTRIBUTE = "SharedAccessKey=";
    @Deprecated
    public static final String SHARED_ACCESS_TOKEN_ATTRIBUTE = "SharedAccessSignature=";
    @Deprecated
    public static final Charset CONNECTION_STRING_CHARSET = StandardCharsets.UTF_8;
    private static final String SET_MINIMUM_POLLING_INTERVAL = "SetMinimumPollingInterval";
    private static final String SET_SEND_INTERVAL = "SetSendInterval";
    private static final String SET_CERTIFICATE_PATH = "SetCertificatePath";
    private static final String SET_SAS_TOKEN_EXPIRY_TIME = "SetSASTokenExpiryTime";
    private DeviceClientConfig config;
    private DeviceIO deviceIO;
    private DeviceTwin deviceTwin;
    private DeviceMethod deviceMethod;
    private FileUpload fileUpload;
    protected long RECEIVE_PERIOD_MILLIS;
    private CustomLogger logger;

    public DeviceClient(String connString, IotHubClientProtocol protocol) throws URISyntaxException {
        this.commonConstructorVerification(connString, protocol);
        IotHubConnectionString iotHubConnectionString = new IotHubConnectionString(connString);
        this.config = new DeviceClientConfig(iotHubConnectionString);
        this.commonConstructorSetup(protocol);
    }

    public DeviceClient(String connString, IotHubClientProtocol protocol, String publicKeyCertificate, boolean isCertificatePath, String privateKey, boolean isPrivateKeyPath) throws URISyntaxException {
        this.commonConstructorVerification(connString, protocol);
        IotHubConnectionString iotHubConnectionString = new IotHubConnectionString(connString);
        this.config = new DeviceClientConfig(iotHubConnectionString, publicKeyCertificate, isCertificatePath, privateKey, isPrivateKeyPath);
        this.commonConstructorSetup(protocol);
    }

    private void commonConstructorVerification(String connString, IotHubClientProtocol protocol) {
        if (connString == null || connString.isEmpty()) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol cannot be null.");
        }
    }

    private void commonConstructorSetup(IotHubClientProtocol protocol) throws IllegalArgumentException, SecurityException, URISyntaxException {
        switch (protocol) {
            case HTTPS: {
                this.RECEIVE_PERIOD_MILLIS = RECEIVE_PERIOD_MILLIS_HTTPS;
                break;
            }
            case AMQPS: {
                this.RECEIVE_PERIOD_MILLIS = RECEIVE_PERIOD_MILLIS_AMQPS;
                break;
            }
            case AMQPS_WS: {
                this.RECEIVE_PERIOD_MILLIS = RECEIVE_PERIOD_MILLIS_AMQPS;
                break;
            }
            case MQTT: {
                this.RECEIVE_PERIOD_MILLIS = RECEIVE_PERIOD_MILLIS_MQTT;
                break;
            }
            case MQTT_WS: {
                this.RECEIVE_PERIOD_MILLIS = RECEIVE_PERIOD_MILLIS_MQTT;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid client protocol specified.");
            }
        }
        this.deviceIO = new DeviceIO(this.config, protocol, SEND_PERIOD_MILLIS, this.RECEIVE_PERIOD_MILLIS);
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClient object is created successfully, method name is %s ", this.logger.getMethodName());
    }

    public void open() throws IOException {
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && this.config.getSasTokenAuthentication().isRenewalNecessary()) {
            throw new SecurityException("Your SasToken is expired");
        }
        this.deviceIO.open();
        this.logger.LogInfo("Connection opened with success, method name is %s ", this.logger.getMethodName());
    }

    @Override
    @Deprecated
    public void close() throws IOException {
        while (!this.deviceIO.isEmpty()) {
        }
        this.deviceIO.close();
        this.logger.LogInfo("Connection closed with success, method name is %s ", this.logger.getMethodName());
    }

    public void closeNow() throws IOException {
        this.deviceIO.close();
        if (this.fileUpload != null) {
            this.fileUpload.closeNow();
        }
        this.logger.LogInfo("Connection closed with success, method name is %s ", this.logger.getMethodName());
    }

    public void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext) {
        this.deviceIO.sendEventAsync(message, callback, callbackContext);
        this.logger.LogInfo("Message with messageid %s along with callback and callbackcontext is added to the queue, method name is %s ", message.getMessageId(), this.logger.getMethodName());
    }

    public DeviceClient setMessageCallback(MessageCallback callback, Object context) {
        if (callback == null && context != null) {
            throw new IllegalArgumentException("Cannot give non-null context for a null callback.");
        }
        this.config.setMessageCallback(callback, context);
        return this;
    }

    public void startDeviceTwin(IotHubEventCallback deviceTwinStatusCallback, Object deviceTwinStatusCallbackContext, PropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException {
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (deviceTwinStatusCallback == null || genericPropertyCallBack == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (this.deviceTwin != null) {
            throw new UnsupportedOperationException("You have already initialised twin");
        }
        this.deviceTwin = new DeviceTwin(this.deviceIO, this.config, deviceTwinStatusCallback, deviceTwinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
        this.deviceTwin.getDeviceTwin();
    }

    public void subscribeToDesiredProperties(Map<Property, Pair<PropertyCallBack<String, Object>, Object>> onDesiredPropertyChange) throws IOException {
        if (this.deviceTwin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        this.deviceTwin.subscribeDesiredPropertiesNotification(onDesiredPropertyChange);
    }

    public void sendReportedProperties(Set<Property> reportedProperties) throws IOException {
        if (this.deviceTwin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (reportedProperties == null || reportedProperties.isEmpty()) {
            throw new IllegalArgumentException("Reported properties set cannot be null or empty.");
        }
        this.deviceTwin.updateReportedProperties(reportedProperties);
    }

    public void subscribeToDeviceMethod(DeviceMethodCallback deviceMethodCallback, Object deviceMethodCallbackContext, IotHubEventCallback deviceMethodStatusCallback, Object deviceMethodStatusCallbackContext) throws IOException {
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (deviceMethodCallback == null || deviceMethodStatusCallback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (this.deviceMethod == null) {
            this.deviceMethod = new DeviceMethod(this.deviceIO, this.config, deviceMethodStatusCallback, deviceMethodStatusCallbackContext);
        }
        this.deviceMethod.subscribeToDeviceMethod(deviceMethodCallback, deviceMethodCallbackContext);
    }

    public void uploadToBlobAsync(String destinationBlobName, InputStream inputStream, long streamLength, IotHubEventCallback callback, Object callbackContext) throws IllegalArgumentException, IOException {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream cannot be null.");
        }
        if (streamLength < 0L) {
            throw new IllegalArgumentException("Invalid stream size.");
        }
        ParserUtility.validateBlobName((String)destinationBlobName);
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
            throw new UnsupportedOperationException("File Upload does not support x509 authentication");
        }
        if (this.fileUpload == null) {
            this.fileUpload = new FileUpload(this.config);
        }
        this.fileUpload.uploadToBlobAsync(destinationBlobName, inputStream, streamLength, callback, callbackContext);
    }

    protected DeviceClient() {
        this.config = null;
        this.deviceIO = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOption_SetMinimumPollingInterval(Object value) {
        this.logger.LogInfo("Setting MinimumPollingInterval as %s milliseconds, method name is %s ", value, this.logger.getMethodName());
        if (this.deviceIO.isOpen()) {
            throw new IllegalStateException("setOption SetMinimumPollingIntervalonly works when the transport is closed");
        }
        if (value == null) throw new IllegalArgumentException("value cannot be null");
        if (!(value instanceof Long)) throw new IllegalArgumentException("value is not long = " + value);
        try {
            this.deviceIO.setReceivePeriodInMilliseconds((Long)value);
            return;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOption_SetSendInterval(Object value) {
        this.logger.LogInfo("Setting send Interval as %s milliseconds, method name is %s ", value, this.logger.getMethodName());
        if (value == null) throw new IllegalArgumentException("value cannot be null");
        if (!(value instanceof Long)) throw new IllegalArgumentException("value is not long = " + value);
        try {
            this.deviceIO.setSendPeriodInMilliseconds((Long)value);
            return;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void setOption_SetCertificatePath(Object value) {
        this.logger.LogInfo("Setting CertificatePath as %s, method name is %s ", value, this.logger.getMethodName());
        if (this.deviceIO.isOpen()) {
            throw new IllegalStateException("setOption SetCertificatePath only works when the transport is closed");
        }
        if (value != null) {
            if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                this.config.getSasTokenAuthentication().setPathToIotHubTrustedCert((String)value);
            } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                this.config.getX509Authentication().setPathToIotHubTrustedCert((String)value);
            }
        } else {
            throw new IllegalArgumentException("value cannot be null");
        }
    }

    private void setOption_SetSASTokenExpiryTime(Object value) {
        this.logger.LogInfo("Setting SASTokenExpiryTime as %s seconds, method name is %s ", value, this.logger.getMethodName());
        if (this.config.getAuthenticationType() != DeviceClientConfig.AuthType.SAS_TOKEN) {
            throw new IllegalStateException("Cannot set sas token validity time when not using sas token authentication");
        }
        if (value != null) {
            if (!(value instanceof Long)) {
                throw new IllegalArgumentException("value is not long = " + value);
            }
            long validTimeInSeconds = (Long)value;
            boolean restart = false;
            if (this.deviceIO.isOpen()) {
                try {
                    if (this.config.getIotHubConnectionString().getSharedAccessKey() != null) {
                        restart = true;
                        this.deviceIO.close();
                    }
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            this.config.getSasTokenAuthentication().setTokenValidSecs(validTimeInSeconds);
            if (restart) {
                try {
                    this.deviceIO.open();
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        } else {
            throw new IllegalArgumentException("value should be in secs");
        }
    }

    public void setOption(String optionName, Object value) {
        if (optionName == null) {
            throw new IllegalArgumentException("optionName is null");
        }
        switch (optionName) {
            case "SetMinimumPollingInterval": {
                if (this.deviceIO.getProtocol() == IotHubClientProtocol.HTTPS) {
                    this.setOption_SetMinimumPollingInterval(value);
                    break;
                }
                this.logger.LogError("optionName is unknown = %s for %s, method name is %s ", optionName, this.deviceIO.getProtocol().toString(), this.logger.getMethodName());
                throw new IllegalArgumentException("optionName is unknown = " + optionName + " for " + this.deviceIO.getProtocol().toString());
            }
            case "SetSendInterval": {
                this.setOption_SetSendInterval(value);
                break;
            }
            case "SetCertificatePath": {
                if (this.deviceIO.getProtocol() == IotHubClientProtocol.AMQPS || this.deviceIO.getProtocol() == IotHubClientProtocol.AMQPS_WS) {
                    this.setOption_SetCertificatePath(value);
                    break;
                }
                this.logger.LogError("optionName is unknown = %s for %s, method name is %s ", optionName, this.deviceIO.getProtocol().toString(), this.logger.getMethodName());
                throw new IllegalArgumentException("optionName is unknown = " + optionName + " for " + this.deviceIO.getProtocol().toString());
            }
            case "SetSASTokenExpiryTime": {
                this.setOption_SetSASTokenExpiryTime(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("optionName is unknown = " + optionName);
            }
        }
    }

    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) {
        if (null == callback) {
            throw new IllegalArgumentException();
        }
        this.deviceIO.registerConnectionStateCallback(callback, callbackContext);
    }
}

