/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthentication;
import com.microsoft.azure.sdk.iot.device.auth.IotHubX509Authentication;

public final class DeviceClientConfig {
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 240000;
    private static final int DEFAULT_MESSAGE_LOCK_TIMEOUT_SECS = 180;
    private boolean useWebsocket;
    private IotHubX509Authentication x509Authentication;
    private IotHubSasTokenAuthentication sasTokenAuthentication;
    private IotHubConnectionString iotHubConnectionString;
    private MessageCallback deviceMethodsMessageCallback;
    private Object deviceMethodsMessageContext;
    private MessageCallback deviceTwinMessageCallback;
    private Object deviceTwinMessageContext;
    private MessageCallback deviceTelemetryMessageCallback;
    private Object deviceTelemetryMessageContext;
    private CustomLogger logger;
    private AuthType authenticationType;

    public DeviceClientConfig(IotHubConnectionString iotHubConnectionString) throws IllegalArgumentException {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("connection string cannot be null");
        }
        if (iotHubConnectionString.isUsingX509()) {
            throw new IllegalArgumentException("Cannot use this constructor for x509 connection strings. Use constructor that takes public key certificate and private key instead");
        }
        this.useWebsocket = false;
        this.authenticationType = AuthType.SAS_TOKEN;
        this.iotHubConnectionString = iotHubConnectionString;
        this.sasTokenAuthentication = new IotHubSasTokenAuthentication(this.iotHubConnectionString.getHostName(), this.iotHubConnectionString.getDeviceId(), this.iotHubConnectionString.getSharedAccessKey(), this.iotHubConnectionString.getSharedAccessToken());
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", iotHubConnectionString.getHostName(), iotHubConnectionString.getDeviceId(), this.logger.getMethodName());
    }

    public DeviceClientConfig(IotHubConnectionString iotHubConnectionString, String publicKeyCertificate, boolean isPathForPublic, String privateKey, boolean isPathForPrivate) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("connection string cannot be null");
        }
        if (!iotHubConnectionString.isUsingX509()) {
            throw new IllegalArgumentException("Cannot use this constructor for connection strings that don't use x509 authentication.");
        }
        this.authenticationType = AuthType.X509_CERTIFICATE;
        this.useWebsocket = false;
        this.iotHubConnectionString = iotHubConnectionString;
        this.x509Authentication = new IotHubX509Authentication(publicKeyCertificate, isPathForPublic, privateKey, isPathForPrivate);
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", iotHubConnectionString.getHostName(), iotHubConnectionString.getDeviceId(), this.logger.getMethodName());
    }

    public IotHubX509Authentication getX509Authentication() {
        return this.x509Authentication;
    }

    public IotHubSasTokenAuthentication getSasTokenAuthentication() {
        return this.sasTokenAuthentication;
    }

    public IotHubConnectionString getIotHubConnectionString() {
        return this.iotHubConnectionString;
    }

    public boolean isUseWebsocket() {
        return this.useWebsocket;
    }

    public void setUseWebsocket(boolean useWebsocket) {
        this.useWebsocket = useWebsocket;
    }

    public void setMessageCallback(MessageCallback callback, Object context) {
        this.deviceTelemetryMessageCallback = callback;
        this.deviceTelemetryMessageContext = context;
    }

    public String getIotHubHostname() {
        return this.iotHubConnectionString.getHostName();
    }

    public String getIotHubName() {
        return this.iotHubConnectionString.getHubName();
    }

    public String getDeviceId() {
        return this.iotHubConnectionString.getDeviceId();
    }

    public int getReadTimeoutMillis() {
        return 240000;
    }

    public MessageCallback getDeviceTelemetryMessageCallback() {
        return this.deviceTelemetryMessageCallback;
    }

    public Object getDeviceTelemetryMessageContext() {
        return this.deviceTelemetryMessageContext;
    }

    public void setDeviceMethodsMessageCallback(MessageCallback callback, Object context) {
        this.deviceMethodsMessageCallback = callback;
        this.deviceMethodsMessageContext = context;
    }

    public MessageCallback getDeviceMethodsMessageCallback() {
        return this.deviceMethodsMessageCallback;
    }

    public Object getDeviceMethodsMessageContext() {
        return this.deviceMethodsMessageContext;
    }

    public void setDeviceTwinMessageCallback(MessageCallback callback, Object context) {
        this.deviceTwinMessageCallback = callback;
        this.deviceTwinMessageContext = context;
    }

    public MessageCallback getDeviceTwinMessageCallback() {
        return this.deviceTwinMessageCallback;
    }

    public Object getDeviceTwinMessageContext() {
        return this.deviceTwinMessageContext;
    }

    public int getMessageLockTimeoutSecs() {
        return 180;
    }

    public AuthType getAuthenticationType() {
        return this.authenticationType;
    }

    protected DeviceClientConfig() {
        this.sasTokenAuthentication = null;
        this.x509Authentication = null;
        this.iotHubConnectionString = null;
        this.deviceMethodsMessageCallback = null;
        this.deviceTelemetryMessageCallback = null;
        this.deviceTwinMessageCallback = null;
        this.deviceMethodsMessageContext = null;
        this.deviceTelemetryMessageContext = null;
        this.deviceTwinMessageContext = null;
        this.logger = null;
        this.useWebsocket = false;
    }

    public static enum AuthType {
        X509_CERTIFICATE,
        SAS_TOKEN;

    }
}

