/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubResponseCallback;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.transport.IotHubReceiveTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubSendTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTransport;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransport;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttTransport;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class DeviceIO {
    private long sendPeriodInMilliseconds;
    private long receivePeriodInMilliseconds;
    private CustomLogger logger;
    private IotHubTransport transport;
    private DeviceClientConfig config;
    private IotHubSendTask sendTask = null;
    private IotHubReceiveTask receiveTask = null;
    private IotHubClientProtocol protocol = null;
    private ScheduledExecutorService taskScheduler;
    private IotHubClientState state;

    DeviceIO(DeviceClientConfig config, IotHubClientProtocol protocol, long sendPeriodInMilliseconds, long receivePeriodInMilliseconds) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null.");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol cannot be null.");
        }
        this.config = config;
        this.protocol = protocol;
        switch (protocol) {
            case HTTPS: {
                this.config.setUseWebsocket(false);
                this.transport = new HttpsTransport(this.config);
                break;
            }
            case AMQPS: {
                this.config.setUseWebsocket(false);
                this.transport = new AmqpsTransport(this.config);
                break;
            }
            case AMQPS_WS: {
                this.config.setUseWebsocket(true);
                this.transport = new AmqpsTransport(this.config);
                break;
            }
            case MQTT: {
                this.config.setUseWebsocket(false);
                this.transport = new MqttTransport(this.config);
                break;
            }
            case MQTT_WS: {
                this.config.setUseWebsocket(true);
                this.transport = new MqttTransport(this.config);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid client protocol specified.");
            }
        }
        this.sendPeriodInMilliseconds = sendPeriodInMilliseconds;
        this.receivePeriodInMilliseconds = receivePeriodInMilliseconds;
        this.state = IotHubClientState.CLOSED;
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceIO object is created successfully, method name is %s ", this.logger.getMethodName());
    }

    public void open() throws IOException {
        if (this.state == IotHubClientState.OPEN) {
            return;
        }
        this.transport.open();
        this.sendTask = new IotHubSendTask(this.transport);
        this.receiveTask = new IotHubReceiveTask(this.transport);
        this.taskScheduler = Executors.newScheduledThreadPool(2);
        this.taskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.state = IotHubClientState.OPEN;
    }

    public void close() throws IOException {
        if (this.state == IotHubClientState.CLOSED) {
            return;
        }
        this.taskScheduler.shutdown();
        this.transport.close();
        this.state = IotHubClientState.CLOSED;
    }

    public void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext) {
        if (this.state == IotHubClientState.CLOSED) {
            throw new IllegalStateException("Cannot send event from an IoT Hub client that is closed.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Cannot send message 'null'.");
        }
        this.logger.LogInfo("Message with messageid %s along with callback and callbackcontext is added to the queue, method name is %s ", message.getMessageId(), this.logger.getMethodName());
        this.transport.addMessage(message, callback, callbackContext);
    }

    public void sendEventAsync(Message message, IotHubResponseCallback callback, Object callbackContext) {
        if (this.state == IotHubClientState.CLOSED) {
            throw new IllegalStateException("Cannot send event from an IoT Hub client that is closed.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Cannot send message 'null'.");
        }
        this.logger.LogInfo("Message with messageid %s along with callback and callbackContext is added to the queue, method name is %s ", message.getMessageId(), this.logger.getMethodName());
        this.transport.addMessage(message, callback, callbackContext);
    }

    public long getReceivePeriodInMilliseconds() {
        return this.receivePeriodInMilliseconds;
    }

    public void setReceivePeriodInMilliseconds(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("receive interval can not be zero or negative");
        }
        this.receivePeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.taskScheduler != null) {
            if (this.receiveTask == null) {
                throw new IOException("transport receive task not set");
            }
            this.taskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public long getSendPeriodInMilliseconds() {
        return this.sendPeriodInMilliseconds;
    }

    public void setSendPeriodInMilliseconds(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("send interval can not be zero or negative");
        }
        this.sendPeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.taskScheduler != null) {
            if (this.sendTask == null) {
                throw new IOException("transport send task not set");
            }
            this.taskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public IotHubClientProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isOpen() {
        return this.state == IotHubClientState.OPEN;
    }

    public boolean isEmpty() {
        return this.transport.isEmpty();
    }

    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) {
        this.transport.registerConnectionStateCallback(callback, callbackContext);
    }

    protected static enum IotHubClientState {
        OPEN,
        CLOSED;

    }
}

