/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

public enum IotHubStatusCode {
    OK,
    OK_EMPTY,
    BAD_FORMAT,
    UNAUTHORIZED,
    TOO_MANY_DEVICES,
    HUB_OR_DEVICE_ID_NOT_FOUND,
    PRECONDITION_FAILED,
    REQUEST_ENTITY_TOO_LARGE,
    THROTTLED,
    INTERNAL_SERVER_ERROR,
    SERVER_BUSY,
    ERROR,
    MESSAGE_EXPIRED,
    MESSAGE_CANCELLED_ONCLOSE;


    public static IotHubStatusCode getIotHubStatusCode(int httpsStatus) {
        IotHubStatusCode iotHubStatus;
        switch (httpsStatus) {
            case 200: {
                iotHubStatus = OK;
                break;
            }
            case 204: {
                iotHubStatus = OK_EMPTY;
                break;
            }
            case 400: {
                iotHubStatus = BAD_FORMAT;
                break;
            }
            case 401: {
                iotHubStatus = UNAUTHORIZED;
                break;
            }
            case 403: {
                iotHubStatus = TOO_MANY_DEVICES;
                break;
            }
            case 404: {
                iotHubStatus = HUB_OR_DEVICE_ID_NOT_FOUND;
                break;
            }
            case 412: {
                iotHubStatus = PRECONDITION_FAILED;
                break;
            }
            case 413: {
                iotHubStatus = REQUEST_ENTITY_TOO_LARGE;
                break;
            }
            case 429: {
                iotHubStatus = THROTTLED;
                break;
            }
            case 500: {
                iotHubStatus = INTERNAL_SERVER_ERROR;
                break;
            }
            case 503: {
                iotHubStatus = SERVER_BUSY;
                break;
            }
            default: {
                iotHubStatus = ERROR;
            }
        }
        return iotHubStatus;
    }
}

