/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubCertificateManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

public class IotHubSSLContext {
    private SSLContext iotHubSslContext = null;
    private static final String SSL_CONTEXT_INSTANCE = "TLSv1.2";
    private static final String CERTIFICATE_ALIAS = "cert-alias";
    private static final String PRIVATE_KEY_ALIAS = "key-alias";
    private static final String TRUSTED_IOT_HUB_CERT_PREFIX = "trustedIotHubCert-";

    IotHubSSLContext() throws KeyStoreException, KeyManagementException, IOException, CertificateException, NoSuchAlgorithmException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        this.generateDefaultSSLContext(defaultCert);
    }

    IotHubSSLContext(String trustedCert, boolean isTrustedCert) throws KeyStoreException, KeyManagementException, IOException, CertificateException, NoSuchAlgorithmException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        if (isTrustedCert) {
            defaultCert.setValidCertPath(trustedCert);
        } else {
            defaultCert.setValidCert(trustedCert);
        }
        this.generateDefaultSSLContext(defaultCert);
    }

    IotHubSSLContext(String publicKeyCertificateString, String privateKeyString, String cert, boolean isPath) throws KeyStoreException, KeyManagementException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        if (isPath) {
            defaultCert.setValidCertPath(cert);
        } else {
            defaultCert.setValidCert(cert);
        }
        this.generateSSLContextWithKeys(publicKeyCertificateString, privateKeyString, defaultCert);
    }

    IotHubSSLContext(String publicKeyCertificateString, String privateKeyString) throws KeyManagementException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.generateSSLContextWithKeys(publicKeyCertificateString, privateKeyString, new IotHubCertificateManager());
    }

    private void generateSSLContextWithKeys(String publicKeyCertificateString, String privateKeyString, IotHubCertificateManager certificateManager) throws KeyManagementException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMReader privateKeyReader = new PEMReader((Reader)new StringReader(privateKeyString));
        PEMReader publicKeyReader = new PEMReader((Reader)new StringReader(publicKeyCertificateString));
        Object possiblePrivateKey = privateKeyReader.readObject();
        if (!(possiblePrivateKey instanceof KeyPair)) {
            throw new CertificateException("Unexpected format for private key");
        }
        KeyPair certPairWithPrivate = (KeyPair)possiblePrivateKey;
        Object possiblePublicKey = publicKeyReader.readObject();
        if (!(possiblePublicKey instanceof X509Certificate)) {
            throw new CertificateException("Unexpected format for public key certificate");
        }
        X509Certificate certPairWithPublic = (X509Certificate)possiblePublicKey;
        char[] temporaryPassword = this.generateTemporaryPassword();
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        keystore.setCertificateEntry(CERTIFICATE_ALIAS, certPairWithPublic);
        keystore.setKeyEntry(PRIVATE_KEY_ALIAS, certPairWithPrivate.getPrivate(), temporaryPassword, new Certificate[]{certPairWithPublic});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, temporaryPassword);
        TrustManagerFactory trustManagerFactory = this.generateTrustManagerFactory(certificateManager, keystore);
        this.iotHubSslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE);
        this.iotHubSslContext.init(kmf.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
    }

    private void generateDefaultSSLContext(IotHubCertificateManager certificateManager) throws KeyStoreException, IOException, CertificateException, KeyManagementException, NoSuchAlgorithmException {
        this.iotHubSslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE);
        TrustManagerFactory trustManagerFactory = this.generateTrustManagerFactory(certificateManager, null);
        this.iotHubSslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
    }

    private TrustManagerFactory generateTrustManagerFactory(IotHubCertificateManager certificateManager, KeyStore trustKeyStore) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        if (trustKeyStore == null) {
            trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustKeyStore.load(null);
        }
        for (Certificate certificate : certificateManager.getCertificateCollection()) {
            trustKeyStore.setCertificateEntry(TRUSTED_IOT_HUB_CERT_PREFIX + UUID.randomUUID(), certificate);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustKeyStore);
        return trustManagerFactory;
    }

    SSLContext getSSlContext() {
        return this.iotHubSslContext;
    }

    private char[] generateTemporaryPassword() {
        return UUID.randomUUID().toString().toCharArray();
    }
}

