/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;

public class IotHubSasTokenAuthentication {
    private long tokenValidSecs = 3600L;
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long MINIMUM_EXPIRATION_TIME_OFFSET = 1L;
    private IotHubSasToken sasToken;
    private IotHubSSLContext iotHubSSLContext;
    private String hostname;
    private String deviceId;
    private String deviceKey;
    private String iotHubTrustedCert;
    private String pathToIotHubTrustedCert;
    private boolean sslContextNeedsUpdate;

    public IotHubSasTokenAuthentication(String hostname, String deviceId, String deviceKey, String sharedAccessToken) throws SecurityException {
        this.hostname = hostname;
        this.deviceId = deviceId;
        this.deviceKey = deviceKey;
        this.sslContextNeedsUpdate = false;
        this.sasToken = new IotHubSasToken(hostname, deviceId, deviceKey, sharedAccessToken, this.tokenValidSecs);
    }

    public String getRenewedSasToken() {
        if (this.deviceKey != null && this.sasToken.isExpired()) {
            Long expiryTime = System.currentTimeMillis() / 1000L + this.tokenValidSecs + 1L;
            this.sasToken = new IotHubSasToken(this.hostname, this.deviceId, this.deviceKey, null, expiryTime);
        }
        return this.sasToken.toString();
    }

    public String getCurrentSasToken() {
        return this.sasToken.toString();
    }

    public SSLContext getSSLContext() throws IOException {
        try {
            if (this.iotHubSSLContext == null || this.sslContextNeedsUpdate) {
                this.iotHubSSLContext = this.generateSSLContext();
            }
            return this.iotHubSSLContext.getSSlContext();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setTokenValidSecs(long tokenValidSecs) {
        this.tokenValidSecs = tokenValidSecs;
    }

    public boolean isRenewalNecessary() {
        return this.sasToken != null && this.sasToken.isExpired() && this.deviceKey == null;
    }

    private IotHubSSLContext generateSSLContext() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        if (this.iotHubTrustedCert != null) {
            return new IotHubSSLContext(this.iotHubTrustedCert, false);
        }
        if (this.pathToIotHubTrustedCert != null) {
            return new IotHubSSLContext(this.pathToIotHubTrustedCert, true);
        }
        return new IotHubSSLContext();
    }

    public void setPathToIotHubTrustedCert(String pathToCertificate) {
        if (this.pathToIotHubTrustedCert == null || !this.pathToIotHubTrustedCert.equals(pathToCertificate)) {
            this.sslContextNeedsUpdate = true;
        }
        this.pathToIotHubTrustedCert = pathToCertificate;
    }

    public void setIotHubTrustedCert(String certificate) {
        if (this.iotHubTrustedCert == null || !this.iotHubTrustedCert.equals(certificate)) {
            this.sslContextNeedsUpdate = true;
        }
        this.iotHubTrustedCert = certificate;
    }
}

