/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class IotHubX509 {
    private String publicKeyCertificate;
    private String privateKey;
    private String pathToPublicKeyCertificate;
    private String pathToPrivateKey;

    IotHubX509(String publicKeyCertificate, boolean isPathForPublic, String privateKey, boolean isPathForPrivate) throws IllegalArgumentException {
        if (publicKeyCertificate == null || publicKeyCertificate.isEmpty()) {
            throw new IllegalArgumentException("Public key certificate cannot be null or empty");
        }
        if (privateKey == null || privateKey.isEmpty()) {
            throw new IllegalArgumentException("Private key certificate cannot be null or empty");
        }
        if (isPathForPublic) {
            this.pathToPublicKeyCertificate = publicKeyCertificate;
        } else {
            this.publicKeyCertificate = publicKeyCertificate;
        }
        if (isPathForPrivate) {
            this.pathToPrivateKey = privateKey;
        } else {
            this.privateKey = privateKey;
        }
    }

    String getPublicKeyCertificate() throws IOException {
        if (this.publicKeyCertificate == null && this.pathToPublicKeyCertificate != null) {
            this.publicKeyCertificate = this.readFromFile(this.pathToPublicKeyCertificate);
        }
        return this.publicKeyCertificate;
    }

    String getPrivateKey() throws IOException {
        if (this.privateKey == null && this.pathToPrivateKey != null) {
            this.privateKey = this.readFromFile(this.pathToPrivateKey);
        }
        return this.privateKey;
    }

    private String readFromFile(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])));
    }
}

