/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.deps.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SignatureHelper {
    private static final String RAW_SIGNATURE_FORMAT = "%s\n%s";
    private static final Charset SIGNATURE_CHARSET = StandardCharsets.UTF_8;

    public static byte[] buildRawSignature(String resourceUri, long expiryTime) {
        return String.format(RAW_SIGNATURE_FORMAT, resourceUri, expiryTime).getBytes(SIGNATURE_CHARSET);
    }

    public static byte[] decodeDeviceKeyBase64(String deviceKey) {
        return Base64.decodeBase64Local((byte[])deviceKey.getBytes());
    }

    public static byte[] encryptSignatureHmacSha256(byte[] sig, byte[] deviceKey) {
        String hmacSha256 = "HmacSHA256";
        SecretKeySpec secretKey = new SecretKeySpec(deviceKey, hmacSha256);
        byte[] encryptedSig = null;
        try {
            Mac hMacSha256 = Mac.getInstance(hmacSha256);
            hMacSha256.init(secretKey);
            encryptedSig = hMacSha256.doFinal(sig);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return encryptedSig;
    }

    public static byte[] encodeSignatureBase64(byte[] sig) {
        return Base64.encodeBase64Local((byte[])sig);
    }

    public static String encodeSignatureUtf8(byte[] sig) {
        return new String(sig, SIGNATURE_CHARSET);
    }

    public static String encodeSignatureWebSafe(String sig) {
        String strSig;
        try {
            strSig = URLEncoder.encode(sig, SIGNATURE_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return strSig;
    }

    protected SignatureHelper() {
    }
}

