/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;

public final class IotHubSendTask
implements Runnable {
    private final IotHubTransport transport;
    private final CustomLogger logger = new CustomLogger(this.getClass());

    public IotHubSendTask(IotHubTransport transport) {
        if (transport == null) {
            this.logger.LogError("IotHubSendTask constructor called with null value for parameter transport", new Object[0]);
            throw new IllegalArgumentException("Parameter 'transport' must not be null");
        }
        this.transport = transport;
    }

    @Override
    public void run() {
        this.logger.LogTrace("Now sending all queued messages to IoT Hub", new Object[0]);
        try {
            this.transport.sendMessages();
            this.logger.LogTrace("Now invoking all queued callbacks", new Object[0]);
            this.transport.invokeCallbacks();
            this.logger.LogTrace("Successfully send all queued messages to IoT Hub", new Object[0]);
        }
        catch (Throwable e) {
            this.logger.LogError(e.toString() + ": " + e.getMessage(), new Object[0]);
            this.logger.LogDebug("Exception on sending queued messages to IoT Hub", e, new Object[0]);
        }
    }
}

