/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.IotHubMethod;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;

public class IotHubTransportMessage
extends Message {
    private IotHubMethod iotHubMethod;
    private String uriPath;
    private String methodName;
    private String version;
    private String requestId;
    private String status;
    private DeviceOperations operationType;

    public IotHubTransportMessage(byte[] data, MessageType messageType) {
        super(data);
        super.setMessageType(messageType);
        this.methodName = null;
        this.version = null;
        this.requestId = null;
        this.status = null;
        this.operationType = DeviceOperations.DEVICE_OPERATION_UNKNOWN;
    }

    public IotHubTransportMessage(String body) {
        super(body);
        super.setMessageType(MessageType.UNKNOWN);
        this.methodName = null;
        this.version = null;
        this.requestId = null;
        this.status = null;
        this.operationType = DeviceOperations.DEVICE_OPERATION_UNKNOWN;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setDeviceOperationType(DeviceOperations deviceOperationType) {
        this.operationType = deviceOperationType;
    }

    public DeviceOperations getDeviceOperationType() {
        return this.operationType;
    }

    public void setMethodName(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Method name cannot be null");
        }
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setIotHubMethod(IotHubMethod iotHubMethod) {
        this.iotHubMethod = iotHubMethod;
    }

    public void setUriPath(String uriPath) {
        this.uriPath = uriPath;
    }

    public IotHubMethod getIotHubMethod() {
        return this.iotHubMethod;
    }

    public String getUriPath() {
        return this.uriPath;
    }
}

