/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceMethods
extends AmqpsDeviceOperations {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String APPLICATION_PROPERTY_KEY_IOTHUB_METHOD_NAME = "IoThub-methodname";
    private static final String APPLICATION_PROPERTY_KEY_IOTHUB_STATUS = "IoThub-status";
    private final String SENDER_LINK_ENDPOINT_PATH = "/devices/%s/methods/devicebound";
    private final String RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/methods/devicebound";
    private final String SENDER_LINK_TAG_PREFIX = "sender_link_devicemethods-";
    private final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_devicemethods-";

    AmqpsDeviceMethods(String deviceId) throws IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("The deviceId cannot be null or empty.");
        }
        this.senderLinkEndpointPath = "/devices/%s/methods/devicebound";
        this.receiverLinkEndpointPath = "/devices/%s/methods/devicebound";
        this.senderLinkTag = "sender_link_devicemethods-" + this.senderLinkTag;
        this.receiverLinkTag = "receiver_link_devicemethods-" + this.receiverLinkTag;
        this.senderLinkAddress = String.format(this.senderLinkEndpointPath, deviceId);
        this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, deviceId);
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:api-version"), "2016-11-14");
        this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)deviceId));
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (messageType == MessageType.DEVICE_METHODS) {
            return super.sendMessageAndGetDeliveryHash(messageType, msgData, offset, length, deliveryTag);
        }
        return new AmqpsSendReturnValue(false, -1);
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, IOException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.DEVICE_METHODS);
        }
        return amqpsMessage;
    }

    @Override
    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) {
        if (amqpsMessage.getAmqpsMessageType() == MessageType.DEVICE_METHODS) {
            Message message = this.protonMessageToIoTHubMessage(amqpsMessage);
            MessageCallback messageCallback = deviceClientConfig.getDeviceMethodsMessageCallback();
            Object messageContext = deviceClientConfig.getDeviceMethodsMessageContext();
            return new AmqpsConvertFromProtonReturnValue(message, messageCallback, messageContext);
        }
        return null;
    }

    @Override
    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) {
        if (message.getMessageType() == MessageType.DEVICE_METHODS) {
            MessageImpl protonMessage = this.iotHubMessageToProtonMessage(message);
            return new AmqpsConvertToProtonReturnValue(protonMessage, MessageType.DEVICE_METHODS);
        }
        return null;
    }

    @Override
    protected Message protonMessageToIoTHubMessage(MessageImpl protonMsg) {
        byte[] msgBody;
        Data d = (Data)protonMsg.getBody();
        if (d != null) {
            Binary b = d.getValue();
            msgBody = new byte[b.getLength()];
            ByteBuffer buffer = b.asByteBuffer();
            buffer.get(msgBody);
        } else {
            msgBody = new byte[]{};
        }
        IotHubTransportMessage iotHubTransportMessage = new IotHubTransportMessage(msgBody, MessageType.DEVICE_METHODS);
        Properties properties = protonMsg.getProperties();
        if (properties != null) {
            if (properties.getCorrelationId() != null) {
                iotHubTransportMessage.setRequestId(properties.getCorrelationId().toString());
            }
            if (properties.getMessageId() != null) {
                iotHubTransportMessage.setMessageId(properties.getMessageId().toString());
            }
            if (properties.getTo() != null) {
                iotHubTransportMessage.setProperty("iothub-app-to", properties.getTo());
            }
            if (properties.getUserId() != null) {
                iotHubTransportMessage.setProperty("iothub-app-userId", properties.getUserId().toString());
            }
        }
        if (protonMsg.getApplicationProperties() != null) {
            Map applicationProperties = protonMsg.getApplicationProperties().getValue();
            for (Map.Entry entry : applicationProperties.entrySet()) {
                String propertyKey = (String)entry.getKey();
                if (propertyKey.equals(APPLICATION_PROPERTY_KEY_IOTHUB_METHOD_NAME)) {
                    iotHubTransportMessage.setMethodName((String)entry.getValue());
                    continue;
                }
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(propertyKey)) continue;
                iotHubTransportMessage.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
        return iotHubTransportMessage;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) {
        IotHubTransportMessage deviceMethodMessage = (IotHubTransportMessage)message;
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        if (deviceMethodMessage.getMessageId() != null) {
            properties.setMessageId((Object)deviceMethodMessage.getMessageId());
        }
        if (deviceMethodMessage.getRequestId() != null) {
            properties.setCorrelationId((Object)UUID.fromString(deviceMethodMessage.getRequestId()));
        }
        outgoingMessage.setProperties(properties);
        int propertiesLength = deviceMethodMessage.getProperties().length;
        HashMap<String, Object> userProperties = new HashMap<String, Object>(propertiesLength);
        if (propertiesLength > 0) {
            for (MessageProperty messageProperty : deviceMethodMessage.getProperties()) {
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(messageProperty.getName())) continue;
                userProperties.put(messageProperty.getName(), messageProperty.getValue());
            }
        }
        if (deviceMethodMessage.getStatus() != null) {
            userProperties.put(APPLICATION_PROPERTY_KEY_IOTHUB_STATUS, Integer.parseInt(deviceMethodMessage.getStatus()));
        }
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        outgoingMessage.setApplicationProperties(applicationProperties);
        Binary binary = new Binary(deviceMethodMessage.getBytes());
        Data section = new Data(binary);
        outgoingMessage.setBody((Section)section);
        return outgoingMessage;
    }
}

