/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AmqpsDeviceOperations {
    protected static final String VERSION_IDENTIFIER_KEY = "com.microsoft:client-version";
    protected static final String API_VERSION_KEY = "com.microsoft:api-version";
    protected static final String API_VERSION_VALUE = "2016-11-14";
    protected static final String TO_KEY = "to";
    protected static final String USER_ID_KEY = "userId";
    protected static final String AMQPS_APP_PROPERTY_PREFIX = "iothub-app-";
    Map<Symbol, Object> amqpProperties = new HashMap<Symbol, Object>();
    protected String senderLinkTag;
    protected String receiverLinkTag;
    protected String senderLinkEndpointPath;
    protected String receiverLinkEndpointPath;
    protected String senderLinkAddress;
    protected String receiverLinkAddress;
    protected Sender senderLink;
    protected Receiver receiverLink;

    AmqpsDeviceOperations() {
        String uuidStr;
        this.amqpProperties.put(Symbol.getSymbol((String)VERSION_IDENTIFIER_KEY), "com.microsoft.azure.sdk.iot.iot-device-client/1.5.37");
        this.senderLinkTag = uuidStr = UUID.randomUUID().toString();
        this.receiverLinkTag = uuidStr;
        this.senderLinkEndpointPath = "";
        this.receiverLinkEndpointPath = "";
        this.senderLinkAddress = "";
        this.receiverLinkAddress = "";
        this.senderLink = null;
        this.receiverLink = null;
    }

    protected void openLinks(Session session) throws IOException, IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("The session cannot be null.");
        }
        try {
            this.receiverLink = session.receiver(this.getReceiverLinkTag());
            this.senderLink = session.sender(this.getSenderLinkTag());
            this.receiverLink.setProperties(this.getAmqpProperties());
            this.senderLink.setProperties(this.getAmqpProperties());
            this.receiverLink.open();
            this.senderLink.open();
        }
        catch (Exception e) {
            throw new IOException("Proton exception: " + e.getMessage());
        }
    }

    protected void closeLinks() {
        if (this.senderLink != null) {
            this.senderLink.close();
            this.senderLink = null;
        }
        if (this.receiverLink != null) {
            this.receiverLink.close();
            this.receiverLink = null;
        }
    }

    protected void initLink(Link link) throws IOException, IllegalArgumentException {
        if (link == null) {
            throw new IllegalArgumentException("The link cannot be null.");
        }
        try {
            if (link.getName().equals(this.getSenderLinkTag())) {
                Target target = new Target();
                target.setAddress(this.getSenderLinkAddress());
                link.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            }
            if (link.getName().equals(this.getReceiverLinkTag())) {
                Source source = new Source();
                source.setAddress(this.getReceiverLinkAddress());
                link.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            }
        }
        catch (Exception e) {
            throw new IOException("Proton exception: " + e.getMessage());
        }
    }

    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (this.senderLink == null) {
            throw new IllegalStateException("Trying to send but Sender link is not initialized.");
        }
        if (deliveryTag.length == 0) {
            throw new IllegalArgumentException("Trying deliveryTag cannot be null.");
        }
        Delivery delivery = this.senderLink.delivery(deliveryTag);
        try {
            this.senderLink.send(msgData, offset, length);
            this.senderLink.advance();
            return new AmqpsSendReturnValue(true, delivery.hashCode());
        }
        catch (Exception e) {
            this.senderLink.advance();
            delivery.free();
            return new AmqpsSendReturnValue(false, -1);
        }
    }

    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, IOException {
        if (linkName.isEmpty()) {
            throw new IllegalArgumentException("The linkName cannot be empty.");
        }
        try {
            Delivery delivery = this.receiverLink.current();
            if (linkName.equals(this.getReceiverLinkTag()) && delivery != null && delivery.isReadable() && !delivery.isPartial()) {
                int size = delivery.pending();
                byte[] buffer = new byte[size];
                int read = this.receiverLink.recv(buffer, 0, buffer.length);
                this.receiverLink.advance();
                AmqpsMessage amqpsMessage = new AmqpsMessage();
                amqpsMessage.setDelivery(delivery);
                amqpsMessage.decode(buffer, 0, read);
                return amqpsMessage;
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException("Proton exeption: " + e.getMessage());
        }
    }

    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws IOException {
        return null;
    }

    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) throws IOException {
        return null;
    }

    protected Message protonMessageToIoTHubMessage(MessageImpl protonMsg) throws IOException {
        return null;
    }

    protected MessageImpl iotHubMessageToProtonMessage(Message message) throws IOException {
        return null;
    }

    Map<Symbol, Object> getAmqpProperties() {
        return this.amqpProperties;
    }

    String getSenderLinkTag() {
        return this.senderLinkTag;
    }

    String getReceiverLinkTag() {
        return this.receiverLinkTag;
    }

    String getSenderLinkAddress() {
        return this.senderLinkAddress;
    }

    String getReceiverLinkAddress() {
        return this.receiverLinkAddress;
    }
}

