/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceTelemetry
extends AmqpsDeviceOperations {
    private final String SENDER_LINK_ENDPOINT_PATH = "/devices/%s/messages/events";
    private final String RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/messages/devicebound";
    private final String SENDER_LINK_TAG_PREFIX = "sender_link_telemetry-";
    private final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_telemetry-";

    AmqpsDeviceTelemetry(String deviceId) throws IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("The deviceId cannot be null or empty.");
        }
        this.senderLinkEndpointPath = "/devices/%s/messages/events";
        this.receiverLinkEndpointPath = "/devices/%s/messages/devicebound";
        this.senderLinkTag = "sender_link_telemetry-" + this.senderLinkTag;
        this.receiverLinkTag = "receiver_link_telemetry-" + this.receiverLinkTag;
        this.senderLinkAddress = String.format(this.senderLinkEndpointPath, deviceId);
        this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, deviceId);
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (messageType == MessageType.DEVICE_TELEMETRY) {
            return super.sendMessageAndGetDeliveryHash(messageType, msgData, offset, length, deliveryTag);
        }
        return new AmqpsSendReturnValue(false, -1);
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, IOException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.DEVICE_TELEMETRY);
        }
        return amqpsMessage;
    }

    @Override
    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) {
        if (amqpsMessage.getAmqpsMessageType() == null || amqpsMessage.getAmqpsMessageType() == MessageType.DEVICE_TELEMETRY) {
            Message message = this.protonMessageToIoTHubMessage(amqpsMessage);
            MessageCallback messageCallback = deviceClientConfig.getDeviceTelemetryMessageCallback();
            Object messageContext = deviceClientConfig.getDeviceTelemetryMessageContext();
            return new AmqpsConvertFromProtonReturnValue(message, messageCallback, messageContext);
        }
        return null;
    }

    @Override
    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) {
        if (message.getMessageType() == null || message.getMessageType() == MessageType.DEVICE_TELEMETRY) {
            MessageImpl protonMessage = this.iotHubMessageToProtonMessage(message);
            return new AmqpsConvertToProtonReturnValue(protonMessage, MessageType.DEVICE_TELEMETRY);
        }
        return null;
    }

    @Override
    protected Message protonMessageToIoTHubMessage(MessageImpl protonMsg) {
        byte[] msgBody;
        Data d = (Data)protonMsg.getBody();
        if (d != null) {
            Binary b = d.getValue();
            msgBody = new byte[b.getLength()];
            ByteBuffer buffer = b.asByteBuffer();
            buffer.get(msgBody);
        } else {
            msgBody = new byte[]{};
        }
        Message message = new Message(msgBody);
        message.setMessageType(MessageType.DEVICE_TELEMETRY);
        Properties properties = protonMsg.getProperties();
        if (properties != null) {
            if (properties.getCorrelationId() != null) {
                message.setCorrelationId(properties.getCorrelationId().toString());
            }
            if (properties.getMessageId() != null) {
                message.setMessageId(properties.getMessageId().toString());
            }
            if (properties.getTo() != null) {
                message.setProperty("iothub-app-to", properties.getTo());
            }
            if (properties.getUserId() != null) {
                message.setProperty("iothub-app-userId", properties.getUserId().toString());
            }
        }
        if (protonMsg.getApplicationProperties() != null) {
            Map applicationProperties = protonMsg.getApplicationProperties().getValue();
            for (Map.Entry entry : applicationProperties.entrySet()) {
                String propertyKey = (String)entry.getKey();
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(propertyKey)) continue;
                message.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return message;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) {
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        if (message.getMessageId() != null) {
            properties.setMessageId((Object)message.getMessageId());
        }
        if (message.getCorrelationId() != null) {
            properties.setCorrelationId((Object)message.getCorrelationId());
        }
        outgoingMessage.setProperties(properties);
        if (message.getProperties().length > 0) {
            HashMap<String, String> userProperties = new HashMap<String, String>(message.getProperties().length);
            for (MessageProperty messageProperty : message.getProperties()) {
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(messageProperty.getName())) continue;
                userProperties.put(messageProperty.getName(), messageProperty.getValue());
            }
            ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
            outgoingMessage.setApplicationProperties(applicationProperties);
        }
        Binary binary = new Binary(message.getBytes());
        Data section = new Data(binary);
        outgoingMessage.setBody((Section)section);
        return outgoingMessage;
    }
}

